
Hello All,

Some time ago I asked you if somebody had a 'alloca' function for Turbo C.
Well I answer my own question with the following code I made.
I haven't tested it yet, so if some of you would like to take a look at it
and tell me your experiences, please do.

I should work with other compilers too. The code must be changed
for machines that have a stack that grows in upward direction.

This code is modelled after the alloca function that accompanies GNU C, but
it is supposed to be faster (and therefore isn't as portable as its example).



----------------------------- CUT HERE ---------------------------

alloca.h:
=========

/*  alloca.c -- alloca work-alike for compilers that don't support it

    Standard configuration for MS-DOS, other OS'es may need some changes.

    No money-back, no guarantee software.

    Author:  R. Kooijman
 */


void *alloca(unsigned int size);





alloca.c:
=========

/*  alloca.c -- alloca work-alike for compilers that don't support it

    Standard configuration for MS-DOS, other OS'es may need some changes.

    No money-back, no guarantee software.

    Author:  R. Kooijman
 */


#include <stddef.h>



#define MAXSTACK       65535U   /*  max value of stack pointer          */
                                /*  on INTEL processors this is 0xFFFF  */


#define ALLOCA_SPACE     8192   /*  standard 8K of alloca stack space  */

static unsigned char alloca_stack[ALLOCA_SPACE];


static unsigned int lastindex, lastsize;


#define OFFSET      sizeof(unsigned int)
#define OFFSET2     (OFFSET+OFFSET)



void *alloca(unsigned int size)
{
unsigned int index;


#ifdef __TURBOC__
   index = MAXSTACK - (unsigned int) _SP;     /*  index into alloca_stack  */
#else
   index = MAXSTACK - (unsigned int) &index;  /*  index into alloca_stack  */
#endif


   while (index < lastindex)    /*  if we returned higher in the stack  */
                                /*  recurse back until we are back in   */
                                /*  the right 'context'                 */
   {
      lastindex = *((unsigned int *) &alloca_stack[lastindex]);
      lastsize  = *((unsigned int *) &alloca_stack[lastindex+OFFSET]);
   }

   /*  first do the recursion (if possible), and then the check for    */
   /*  invalid 'size' values; this way you can recall allocated space  */
   /*  by doing an alloca(0) at a higher level in your program         */
   if (size == 0)
      return(NULL);             /*  return NULL if size requested == 0  */

   if (index < lastindex + lastsize)
      index = lastindex + lastsize;
                                /*  two consecutive calls to alloca give  */
                                /*  equal values for index, so save       */
                                /*  enough space by updating index        */

   size += OFFSET2;             /*  extra space for lastindex and lastsize  */

   if (index + size > ALLOCA_SPACE)
      return(NULL);             /*  not enough space in alloca_stack  */

   /*  update indices and sizes  */
   *((unsigned int *) &alloca_stack[index])        = lastindex;
   *((unsigned int *) &alloca_stack[index+OFFSET]) = lastsize;

   lastindex = index;
   lastsize  = size;

   return((void *) &alloca_stack[index+OFFSET2]);
}

--- 
 * Origin: C_BBS, "C" how does that spell?,..31-4930-20361/20792 (2:284/203)

