/*
** A Link in a Singly Linked List Declaration
**
** Purpose:
**	A node object in a singly linked list with the pointer to
**	the next object in the list.  Used in conjunction with Slist.
*/

#ifndef SLINK_HPP
#define SLINK_HPP

#include <iostream.h>

#ifndef OBJECT_HPP
#include "Object.hpp"
#endif /* OBJECT_HPP */

class Addrlist;

class Dict;

class Slink : public Object {
private:
	Object*	dataptr;			// point to data in link

protected:
	Slink*	next;				// next link in list

public:
	Slink(Object* =0, Slink* =0);		// don't allow NULL data
	~Slink();				// destroy ONLY this link

	Object*	getdata();			// return data ptr
	Slink*	getnext();			// return next ptr

	void	setdata(Object* =0);		// set data ptr
	void	setnext(Slink* =0);		// set next ptr

	void 	WriteTo(ostream&, Addrlist&);
						// linearize link
	void	ReadFrom(istream&, Dict&);
						// delinearize link
	Object*	CreateMe();			// for delinearization
};

#endif /* SLINK_HPP */
