/*
** Ref Declaration
**
** Purpose:
**	Holds the reference for dictionary list.  A reference
**	is the string name of the object and a pointer to a (psuedo)
**	version of the object used to create (define) it.
*/

#ifndef REF_HPP
#include "Ref.hpp"
#endif /* REF_HPP */

#include <iostream.h>
#include <iomanip.h>

#ifndef CONS_HPP
#include "cons.hpp"
#endif /* CONS_HPP */

#ifndef ADDRLIST_HPP
#include "Addrlist.hpp"
#endif /* ADDRLIST_HPP */

#ifndef ADDRESS_HPP
#include "Address.hpp"
#endif /* ADDRESS_HPP */

#ifndef DICT_HPP
#include "Dict.hpp"
#endif /* DICT_HPP */

Ref::Ref() {
	DPRINT("Ref::Ref()");
	name[0] = '\0';
	objptr = (Object*) 0;
}

Ref::Ref(char* iname, Object* iobj) {
	DPRINT("Ref::Ref(char*, Object*)");
	strcpy(name, iname);
	objptr = iobj;
}

Ref::~Ref() {
	DPRINT("Ref::~Ref");
	delete objptr;
}

void	Ref::WriteTo(ostream& s, Addrlist& a) {
	DPRINT("Ref::WriteTo");

	STARTWRITE(s, a, "Ref");
	Object::WriteTo(s, a);			// handle parent
	s << setw(25) << name << " ";		// handle the name
	if (objptr && !a.find((void*) objptr))	// seen object before?
		objptr->WriteTo(s, a);		// no, write it out
	s << ((long) objptr) << " ";		// and its address
	ENDWRITE(s);
}

void	Ref::ReadFrom(istream& s, Dict& a) {
	DPRINT("Ref::ReadFrom");

	STARTREAD(s, a, "Ref");
	Object::ReadFrom(s, a);			// process parent

	int	foundobject = 0;
	char	ch = 0,
		itoken[100],
		*p = itoken;

	for (int i = 0; i < 25; i++) {
		s.get(ch);
		if (ch != ' ')
			*p++ = ch;
	}
	*p = '\0';
	strcpy(name, itoken);			// process the name

	s >> ch;				// look for '{'
	s.putback(ch);				// just browsing

	if (ch == '{') {			// process pointed to object
		s >> ch;			// process the '{'

		objptr = (Ref*) check_dict(s);

		s.putback(ch);			// let object handle it

		if (objptr) {
			foundobject = 1;
			objptr->ReadFrom(s, a);	// process the object
		}
		else
			return;			// hmmmm
	}

	s >> itoken;				// process the object address
	if (!foundobject) {
		int i = a.find(itoken);
		Ref* ref = (Ref*) a.get(i);
		objptr = ref->getobject();
	}

	ENDREAD(s);
}

Object*	Ref::CreateMe() {
	DPRINT("Ref::CreateMe");
	return(new Ref);
}

int	Ref::operator==(Ref& a) {
	DPRINT("Ref::operator==(Ref&)");
	return(!(strcmp(name, a.name)));
}

int	Ref::operator==(char* s) {
	DPRINT("Ref::operator==(char*)");
	return(!(strcmp(name, s)));
}

char*	Ref::getname() {
	DPRINT("Ref::getname");
	return(name);
}

Object*	Ref::getobject() {
	DPRINT("Ref::getobject");
	return(objptr);
}
