/*
** Abstract Object Declaraction
**
** Purpose:
**	The top of the inheritance hierarchy.
*/

#ifndef OBJECT_HPP
#define OBJECT_HPP

#include <iostream.h>

class Addrlist;

class Dict;

class Object {
	static Dict* objdict;
						// Every object knows where the
						// ...dictionary is and 
						// ...how to use it.

public:
	Object();				// use it as an abstract class
	Object(Dict*);			// first assign a dictionary
	virtual ~Object();			// special for each object

	virtual void	WriteTo(ostream&, Addrlist&);
				// virtual linearize object capability
	virtual void	ReadFrom(istream&, Dict&);
				// virtual delinearize object capability
	virtual Object*	CreateMe();
				// virtual something to delinearize into

	Object*	check_dict(istream&);
				// interface with internal dictionary

	friend ostream& operator<<(ostream& s, Object& o);
						// maintain standard capability
	friend istream& operator>>(istream& s, Object& o);
						// maintain standard capability
};

#endif /* OBJECT_HPP */
