/*
** Abstract Object Definition
**
** Purpose:
**	The top of the inheritance hierarchy.
*/

#ifndef OBJECT_HPP
#include "Object.hpp"
#endif /* OBJECT_HPP */

#include <iostream.h>

#ifndef CONS_HPP
#include "cons.hpp"
#endif /* CONS_HPP */

#ifndef ADDRLIST_HPP
#include "Addrlist.hpp"
#endif /* ADDRLIST_HPP */

#ifndef ADDRESS_HPP
#include "Address.hpp"
#endif /* ADDRESS_HPP */

#ifndef DICT_HPP
#include "Dict.hpp"
#endif /* DICT_HPP */

#ifndef REF_HPP
#include "Ref.hpp"
#endif /* REF_HPP */

ostream& operator<<(ostream& s, Object& o) {
	DPRINT("operator<<");
	Addrlist	adrlst;

	o.WriteTo(s, adrlst);
	return(s);
}

istream& operator>>(istream& s, Object& o) {
	DPRINT("operator>>");
	Dict	iodict;

	iodict.add("0", (Object*) 0);		// Null pointer seed

	o.ReadFrom(s, iodict);
	return(s);
}

Object::Object() {
	DPRINT("Object::Object()");
}

Object::Object(Dict* a) {
	DPRINT("Object::Object(Dict*)");
	objdict = a;
}		

Object::~Object() {
	DPRINT("Object::~Object");
}

void	Object::WriteTo(ostream& s, Addrlist& a) {
	DPRINT("Object::WriteTo");

	STARTWRITE(s, a, "Object");
	ENDWRITE(s);
}

void	Object::ReadFrom(istream& s, Dict& a) {
	DPRINT("Object::ReadFrom");

	STARTREAD(s, a, "Object");
	ENDREAD(s);
}

Object*	Object::CreateMe() {
	DPRINT("Object::CreateMe");
	return(new Object);
}

Object* Object::check_dict(istream& s) {
	DPRINT("Object::check_dict");
	return(objdict->findobject(s));
}
