/*
** Name Object Definition
**
** Purpose:
**	Maintain a fixed-length character string.
*/

#ifndef NAME_HPP
#include "Name.hpp"
#endif /* NAME_HPP */

#include <iostream.h>
#include <iomanip.h>

#ifndef CONS_HPP
#include "cons.hpp"
#endif /* CONS_HPP */

#ifndef ADDRLIST_HPP
#include "Addrlist.hpp"
#endif /* ADDRLIST_HPP */

#ifndef ADDRESS_HPP
#include "Address.hpp"
#endif /* ADDRESS_HPP */

#ifndef DICT_HPP
#include "Dict.hpp"
#endif /* DICT_HPP */

Name::Name(char* a) {
	DPRINT("Name::Name");
	strcpy(name, (a) ? a : "");		// blank default
}

Name::~Name() {
	DPRINT("Name::~Name");
}

char*	Name::getvalue() {
	DPRINT("Name::getvalue");
	return(name);
}

void	Name::WriteTo(ostream& s, Addrlist& a) {
	DPRINT("Name::WriteTo");

	STARTWRITE(s, a, "Name");
	Object::WriteTo(s, a);			// handle parent
	s << setw(25) << name << " ";
	ENDWRITE(s);
}

void	Name::ReadFrom(istream& s, Dict& a) {
	DPRINT("Name::ReadFrom");

	STARTREAD(s, a, "Name");
	Object::ReadFrom(s, a);			// process parent

	char	ch = 0,
		itoken[100],
		*p = itoken;

	for (int i = 0; i < 25; i++) {
		s.get(ch);
		if (ch != ' ')
			*p++ = ch;
	}
	*p = '\0';
	strcpy(name, itoken);			// process the incoming name

	ENDREAD(s);
}

Object*	Name::CreateMe() {
	DPRINT("Name::CreateMe");
	return(new Name);
}
