/*
**	Main Test Input Routine
**
** Purpose:
**	Input a stream representing the shippable form of an
**	Object.  This should have been produced by the output routine.
*/

#include <iostream.h>

#ifndef CONS_HPP
#include "cons.hpp"
#endif /* CONS_HPP */

#ifndef OBJECT_HPP
#include "Object.hpp"
#endif /* OBJECT_HPP */

#ifndef SLINK_HPP
#include "Slink.hpp"
#endif /* SLINK_HPP */

#ifndef SLIST_HPP
#include "Slist.hpp"
#endif SLIST_HPP

#ifndef DLINK_HPP
#include "Dlink.hpp"
#endif /* DLINK_HPP */

#ifndef DLIST_HPP
#include "Dlist.hpp"
#endif /* DLIST_HPP */

#ifndef NAME_HPP
#include "Name.hpp"
#endif /* NAME_HPP */

#ifndef ADDRESS_HPP
#include "Address.hpp"
#endif /* ADDRESS_HPP */

#ifndef ADDRLIST_HPP
#include "Addrlist.hpp"
#endif /* ADDRLIST_HPP */

#ifndef REF_HPP
#include "Ref.hpp"
#endif /* REF_HPP */

#ifndef DICT_HPP
#include "Dict.hpp"
#endif /* DICT_HPP */

void	setup_dictionary(Dict& dict) {
	dict.add("Object", new Object);
	dict.add("Slink", new Slink);
	dict.add("Slist", new Slist);
	dict.add("Dlink", new Dlink);
	dict.add("Dlist", new Dlist);
	dict.add("Name", new Name);
	dict.add("Address", new Address);
	dict.add("Addrlist", new Addrlist);
	dict.add("Ref", new Ref);
	dict.add("Dict", new Dict);

	Object	temp(&dict);		// initialize static dictionary
}

int	main()
{
	DPRINT("create process dictionary");
	Dict	dict;		// reference translation

	DPRINT("setup dictionary");
	setup_dictionary(dict);		// setup references

	/*
	** Below here would be callback processing
	** which would be invoked in normal methods
	*/
	DPRINT("callback to build testlist");
	Dlist	testlist;		// perhaps on the heap?

	DPRINT("begin scanning input");
	cin >> testlist;		// that's it!!!

	DPRINT("test that it worked");
	cout << testlist;		// to verify it worked...
}
