/*
** Doubly Linked List Definition
**
** Purpose:
**	Manage a group of Dlinks.
*/

#ifndef DLIST_HPP
#include "Dlist.hpp"
#endif /* DLIST_HPP */

#include <iostream.h>

#ifndef CONS_HPP
#include "cons.hpp"
#endif /* CONS_HPP */

#ifndef ADDRLIST_HPP
#include "Addrlist.hpp"
#endif /* ADDRLIST_HPP */

#ifndef ADDRESS_HPP
#include "Address.hpp"
#endif /* ADDRESS_HPP */

#ifndef DICT_HPP
#include "Dict.hpp"
#endif /* DICT_HPP */

Dlist::Dlist():Slist() {
	DPRINT("Dlist::Dlist()");
	current = 0;
}

Dlist::Dlist(Object* a):Slist(a) {
	DPRINT("Dlist::Dlist(Object*)");
	current = (Dlink*) last->getnext();	// point to head of list
}

Dlist::~Dlist() {
	DPRINT("Dlist::~Dlist");
	clear();				// clear the list first
}

Object*	Dlist::getcurrent() {
	DPRINT("Dlist::getcurrent");
	if (current)				// is there a current?
		return(current->getdata());
	else
		return(0);
}

void	Dlist::WriteTo(ostream& s, Addrlist& a) {
	DPRINT("Dlist::WriteTo");

	STARTWRITE(s, a, "Dlist");
	Slist::WriteTo(s, a);			// handle parent
	if (current && !a.find((void*) current)) // seen current before?
		current->WriteTo(s, a);		// no, write it out
	s << ((long) current) << " ";
	ENDWRITE(s);
}

void	Dlist::ReadFrom(istream& s, Dict& a) {
	DPRINT("Dlist::ReadFrom");

	STARTREAD(s, a, "Dlist");
	Slist::ReadFrom(s, a);			// process parent

	int	foundobject = 0;
	char	ch = 0,
		itoken[100];

	s >> ch;				// look for '{'
	s.putback(ch);				// just browsing

	if (ch == '{') {
		s >> ch;			// process the '{'

		current = (Dlink*) check_dict(s);

		s.putback(ch);			// let object process it

		if (current) {
			foundobject = 1;
			current->ReadFrom(s, a);
		}
		else
			return;			// hmmmm

	}

	s >> itoken;				// process the current pointer
	if (!foundobject) {
		int i = a.find(itoken);
		Ref* ref = (Ref*) a.get(i);
		current = (Dlink*) ref->getobject();
	}

	ENDREAD(s);
}

Object*	Dlist::CreateMe() {
	DPRINT("Dlist::CreateMe");
	return(new Dlist);
}
