/*
** Address List Object Declaration
**
** Purpose:
**	Manage a list of Address objects.
*/

#ifndef ADDRLIST_HPP
#define ADDRLIST_HPP

#include <iostream.h>

#ifndef ADDRESS_HPP
#include "Address.hpp"
#endif /* ADDRESS_HPP */

#ifndef SLIST_HPP
#include "Slist.hpp"
#endif /* SLIST_HPP */

class Dict;

class Addrlist : public Slist {

public:
	Addrlist();				// list with no addresses
	Addrlist(Address*);			// list with first entry
	~Addrlist();				// get rid of list

	int	find(Address*);			// find address in list 
						// ...(0 not found)
	int	add(Address*);			// add new address to list
	int	find(void*);			// find void pointer
	int	add(void*);			// add information to list

	void	WriteTo(ostream&, Addrlist&);	// linearize the list
	void	ReadFrom(istream&, Dict&);	// delinearize the list
	Object* CreateMe();			// for delinearization
};

#endif /* ADDRLIST_HPP */
