/*
** Special functions file
*/

#include <iostream.h>

#ifndef CONS_HPP
#include "cons.hpp"
#endif /* CONS_HPP */

// Get a whitespace terminated token 
// 	from the input stream
char*	gettoken(istream& s) {
	DPRINT("gettoken");
	static char buffer[512];
	int	i = 0;

	while (!s.eof()) {
		s >> buffer[i++];

		if (buffer[i - 1] == ' ') {
			s.putback(buffer[--i]);
			buffer[i] = '\0';
			return(buffer);
		}
	}
	return(0);
}

// Put a string back on the input stream
int	returntoken(istream& s, char* t) {
	DPRINT("returntoken");
	if (!t)
		return(0);

	int i = strlen(t);
	while (--i >= 0) {
		s.putback(t[i]);
		if (!s.good())
			return(0);
	}
	return(1);
}

