/*
** Singly Linked List Definition
**
** Purpose:
**	Manage a group of Slinks.
*/

#ifndef SLIST_HPP
#include "Slist.hpp"
#endif /* SLIST_HPP */

#include <iostream.h>

#ifndef CONS_HPP
#include "cons.hpp"
#endif /* CONS_HPP */

#ifndef ADDRLIST_HPP
#include "Addrlist.hpp"
#endif /* ADDRLIST_HPP */

#ifndef ADDRESS_HPP
#include "Address.hpp"
#endif /* ADDRESS_HPP */

#ifndef DICT_HPP
#include "Dict.hpp"
#endif /* DICT_HPP */

Slist::Slist():Object() {
	DPRINT("Slist::Slist()");
	last = 0;
}

Slist::Slist(Object* a):Object() {
	DPRINT("Slist::Slist(Object*)");
	last = new Slink(a);
	last->setnext(last);
}

Slist::~Slist() {
	DPRINT("Slist::~Slist");
	clear();
}

Object*	Slist::getlast() {
	DPRINT("Slist::getlast");
	if (last)
		return(last->getdata());
	else
		return(0);
}

Object*	Slist::gethead() {
	DPRINT("Slist::gethead");
	if (last) {
		Slink* head = last->getnext();
		return(head->getdata());
	}
	else
		return(0);
}

void	Slist::WriteTo(ostream& s, Addrlist& a) {
	DPRINT("Slist::WriteTo");

	STARTWRITE(s, a, "Slist");
	Object::WriteTo(s, a);			// handle parent
	if (last && !a.find((void*) last))	// seen last before?
		last->WriteTo(s, a);		// no, write it out
	s << ((long) last) << " ";
	ENDWRITE(s);
}

void	Slist::ReadFrom(istream& s, Dict& a) {
	DPRINT("Slist::ReadFrom");

	STARTREAD(s, a, "Slist");
	Object::ReadFrom(s, a);			// process parent

	int	foundobject = 0;
	char	ch = 0,
		itoken[100];

	s >> ch;				// look for the '{'
	s.putback(ch);				// just browsing

	if (ch == '{') {
		s >> ch;			// process the '{'

		last = (Slink*) check_dict(s);

		s.putback(ch);			// let object process it

		if (last) {
			foundobject = 1;
			last->ReadFrom(s, a);
		}
		else
			return;			// hmmmm
	}

	s >> itoken;				// process the last pointer
	if (!foundobject) {
		int i = a.find(itoken);
		Ref* ref = (Ref*) a.get(i);
		last = (Slink*) ref->getobject();
	}

	ENDREAD(s);
}

void	Slist::clear() {
	DPRINT("Slist::clear");
	Slink*	l = last;

	if (l == 0)
		return;

	do {
		Slink*	ll = l;
		l = l->getnext();
		delete ll;
	} while (l != last);
}

int	Slist::add(Object* a) {
	DPRINT("Slist::add");
	if (last) {
		last->setnext(new Slink(a, last->getnext()));
		last = last->getnext();
	}
	else {
		last = new Slink(a);
		last->setnext(last);
	}
	return(0);
}

void	Slist::remove() {
	DPRINT("Slist::remove");
	if (last) {
		Slink*	f = last->getnext();
		last = (f == last) ? 0 : f->getnext();
		delete f;
	}
}

Object*	Slist::get(unsigned int i) {
	DPRINT("Slist::get");
	if (i && last) {
		Slink*	ll = last->getnext();

		while (ll && --i)
			ll = (ll == last) ? 0 : ll->getnext();

		return(ll->getdata());
	}
	else
		return(0);
}

void	Slist::dclear() {
	DPRINT("Slist::dclear");
	Slink*	l = last;

	if (l == 0)
		return;

	do {
		Object* ll = l->getdata();
		delete ll;
		l = l->getnext();
	} while (l != last);
}

Object*	Slist::CreateMe() {
	DPRINT("Slist::CreateMe");
	return(new Slist);
}
