/*
** Address Declaration
**
** Purpose:
**	Holds the address of an unknown thing for later use.
*/

#ifndef ADDRESS_HPP
#define ADDRESS_HPP

#include <iostream.h>

#ifndef OBJECT_HPP
#include "Object.hpp"
#endif /* OBJECT_HPP */

class Addrlist;

class Dict;

class Address : public Object {
	void*	datavalue;			// holds address of thing

public:
	Address(void* =0);			// construct an address object
	~Address();				// destroy an address object

	void*	getvalue();			// return the address
	int	compare(void*);			// (-1 <, 0 =, 1 >)

	int	operator==(void*);		// are they equivalent?
	int	operator==(Address&);		// are they equivalent?

	void	WriteTo(ostream&, Addrlist&);
						// linearize an address
	void	ReadFrom(istream&, Dict&);
						// delinearize an address
	Object* CreateMe();			// for delinearization
};

#endif /* ADDRESS_HPP */
