/*
** Address Definition
**
** Purpose
**	Holds the address of an unknown thing for later use.
*/

#ifndef ADDRESS_HPP
#include "Address.hpp"
#endif /* ADDRESS_HPP */

#include <iostream.h>

#ifndef CONS_HPP
#include "cons.hpp"
#endif /* CONS_HPP */

#ifndef ADDRLIST_HPP
#include "Addrlist.hpp"
#endif /* ADDRLIST_HPP */

#ifndef DICT_HPP
#include "Dict.hpp"
#endif /* DICT_HPP */

Address::Address(void* i) {
	DPRINT("Address::Address");
	datavalue = i;
}

Address::~Address() {
	DPRINT("Address::~Address");
}

void	Address::WriteTo(ostream& s, Addrlist& a) {
	DPRINT("Address::WriteTo");

	STARTWRITE(s, a, "Address");
	Object::WriteTo(s, a);			// handle parent
	s << ((long) datavalue) << " ";
	ENDWRITE(s);
}

void	Address::ReadFrom(istream& s, Dict& a) {
	DPRINT("Address::ReadFrom");

	STARTREAD(s, a, "Address");
	Object::ReadFrom(s, a);			// process parent
	s >> ((int) datavalue);			// useless pointer, but...
	ENDREAD(s);
}

void*	Address::getvalue() {
	DPRINT("Address::getvalue");
	return(datavalue);
}

int	Address::compare(void* ival) {
	DPRINT("Address::compare");
	return((ival == datavalue) ? 0 : (ival > datavalue) ? 1 : -1);
}

int	Address::operator==(void* a) {
	DPRINT("Address::operator==(void*)");
	return(compare(a) ? 0 : 1);
}

int	Address::operator==(Address& a) {
	DPRINT("Address::operator==(Address&)");
	return(compare(a.getvalue()) ? 0 : 1);
}

Object* Address::CreateMe() {
	DPRINT("Address::CreateMe");
	return(new Address);
}
