/*
** Singly Linked List Declaration
**
** Purpose:
**	Manage a group of Slinks.
*/

#ifndef SLIST_HPP
#define SLIST_HPP

#include <iostream.h>

#ifndef OBJECT_HPP
#include "Object.hpp"
#endif /* OBJECT_HPP */

#ifndef SLINK_HPP
#include "Slink.hpp"
#endif /* SLINK_HPP */

class Addrlist;

class Dict;

class Slist : public Object {
protected:
	Slink*	last;				// last->next is head

public:
	Slist();				// list with no links
	Slist(Object*);				// list with first entry
	~Slist();				// get rid of list

	void	clear();			// delete links in list
	void	dclear();			// destructively clear link
						// ...contents, but let 
						// ...clear() delete link.

	int	add(Object*);			// add to end of list
	void	remove();			// remove head of list

	Object*	get(unsigned int =1);		// return ith of list

	Object*	getlast();			// return last in list
	Object*	gethead();			// return head of list

	void 	WriteTo(ostream&, Addrlist&);
						// linearize list
	void	ReadFrom(istream&, Dict&);
						// delinearize list
	Object*	CreateMe();			// for delinearization
};

#endif /* SLIST_HPP */
