/*
** A Link in a Singly Linked List Definition
**
** Purpose:
**	A node object in a singly linked list with the pointer to
**	the next object in the list.  Used in conjunction with Slist.
*/

#ifndef SLINK_HPP
#include "Slink.hpp"
#endif /* SLINK_HPP */

#include <iostream.h>

#ifndef CONS_HPP
#include "cons.hpp"
#endif /* CONS_HPP */

#ifndef ADDRLIST_HPP
#include "Addrlist.hpp"
#endif /* ADDRLIST_HPP */

#ifndef ADDRESS_HPP
#include "Address.hpp"
#endif /* ADDRESS_HPP */

#ifndef DICT_HPP
#include "Dict.hpp"
#endif /* DICT_HPP */

Slink::Slink(Object* a, Slink* b):Object() {
	DPRINT("Slink::Slink");
	setdata(a);
	setnext(b);
}

Slink::~Slink() {
	DPRINT("Slink::~Slink");
}

void	Slink::setdata(Object* a) {
	DPRINT("Slink::setdata");
	dataptr = a;
}

void	Slink::setnext(Slink* a) {
	DPRINT("Slink::setnext");
	next = a;
}

Object*	Slink::getdata() {
	DPRINT("Slink::getdata");
	return(dataptr);
}

Slink*	Slink::getnext() {
	DPRINT("Slink::getnext");
	return(next);
}

void	Slink::WriteTo(ostream& s, Addrlist& a) {
	DPRINT("Slink::WriteTo");

	STARTWRITE(s, a, "Slink");
	Object::WriteTo(s, a);			// handle parent
	if (dataptr && !a.find((void*) dataptr)) // seen dataptr before?
		dataptr->WriteTo(s, a);		// no, write it out
	s << ((long) dataptr) << " ";
	if (next && !a.find((void*) next))	// seen next before?
		next->WriteTo(s, a);		// no, write it out
	s << ((long) next) << " ";
	ENDWRITE(s);
}

void	Slink::ReadFrom(istream& s, Dict& a) {
	DPRINT("Slink::ReadFrom");

	STARTREAD(s, a, "Slink");
	Object::ReadFrom(s, a);			// process parent

	int	foundobject = 0;
	char 	ch = 0,
		itoken[100];

	s >> ch;				// look for '{'
	s.putback(ch);				// just browsing

	if (ch == '{') {			// process dataptr object
		s >> ch;			// process the '{'

		dataptr = (Slink*) check_dict(s);

		s.putback(ch);			// let object handle it

		if (dataptr) {
			foundobject = 1;
			dataptr->ReadFrom(s, a);
		}
		else
			return;			// hmmmm
	}

	s >> itoken;				// process dataptr address
	if (!foundobject) {
		int i = a.find(itoken);
		Ref* ref = (Ref*) a.get(i);
		dataptr = ref->getobject();
	}

	foundobject = 0;			// reset

	s >> ch;				// look for the '{'
	s.putback(ch);				// just browsing

	if (ch == '{') {			// process next object
		s >> ch;			// process the '{'

		next = (Slink*) check_dict(s);

		s.putback(ch);			// let object handle it

		if (dataptr) {
			foundobject = 1;
			next->ReadFrom(s, a);
		}
		else
			return;			// hmmmm
	}

	s >> itoken;				// process next value
	if (!foundobject) {
		int i = a.find(itoken);
		Ref *ref = (Ref*) a.get(i);
		next = (Slink*) ref->getobject();
	}

	ENDREAD(s);
}

Object*	Slink::CreateMe() {
	DPRINT("Slink::CreateMe");
	return(new Slink);
}
