/*
** Ref Declaration
**
** Purpose:
**	Holds the reference for dictionary list.  A reference
**	is the string name of the object and a pointer to a (psuedo)
**	version of the object used to create (define) it.
*/

#ifndef REF_HPP
#define REF_HPP

#include <iostream.h>

#ifndef OBJECT_HPP
#include "Object.hpp"
#endif /* OBJECT_HPP */

class Addrlist;

class Dict;

class Ref : public Object {
	char	name[25];			// name to recognize in input
	Object*	objptr;				// a psuedo reference to 
						// ...the object

public:
	Ref();
	Ref(char*, Object*);
	~Ref();

	int	operator==(Ref&);		// are they equivalent?
	int	operator==(char*);		// proper string?

	char*	getname();			// what's my name?
	Object*	getobject();			// who am I?

	void	WriteTo(ostream&, Addrlist&);
						// linearize a reference
	void	ReadFrom(istream&, Dict&);
						// delinearize a reference
	Object*	CreateMe();			// for delinearization
};

#endif /* REF_HPP */
