/*
** Doubly Linked List Declaration
**
** Purpose:
**	Manage a group of Dlinks.
*/

#ifndef DLIST_HPP
#define DLIST_HPP

#include <iostream.h>

#ifndef OBJECT_HPP
#include "Object.hpp"
#endif /* OBJECT_HPP */

#ifndef SLIST_HPP
#include "Slist.hpp"
#endif /* SLIST_HPP */

#ifndef DLINK_HPP
#include "Dlink.hpp"
#endif /* DLINK_HPP */

class Addrlist;

class Dict;

class Dlist : public Slist {
protected:
	Dlink	*current;			// maintain a current pointer

public:
	Dlist();				// list with no links
	Dlist(Object*);				// list with first entry
	~Dlist();				// get rid of list

	Object*	getcurrent();			// return current object

	void	WriteTo(ostream&, Addrlist&);
						// linearize list
	void	ReadFrom(istream&, Dict&);
						// delinearize list
	Object*	CreateMe();			// for delinearization
};

#endif /* DLIST_HPP */
