/*
** A Link in a Doubly Linked List Declaration
**
** Purpose:
**	A node object in a doubly linked list with pointers to previous
**	and next objects in the list.  Used in conjunction with Dlist.
*/

#ifndef DLINK_HPP
#define DLINK_HPP

#include <iostream.h>

#ifndef OBJECT_HPP
#include "Object.hpp"
#endif /* OBJECT_HPP */

#ifndef SLINK_HPP
#include "Slink.hpp"
#endif /* SLINK_HPP */

class Addrlist;

class Dict;

class Dlink : public Slink {
protected:
	Dlink*	prev;				// previous link in list

public:
	Dlink(Object* =0, Dlink* =0, Dlink* =0);
						// don't allow null data
	~Dlink();				// remove link from list

	Dlink*	getprev();			// get prev ptr
	void	setprev(Dlink*);		// set prev ptr
	
	void	remove();			// remove from list

	void	WriteTo(ostream&, Addrlist&);
						// linearize link
	void	ReadFrom(istream&, Dict&);
						// delinearize link
	Object*	CreateMe();			// for delinearization
};

#endif /* DLINK_HPP */
