/*
** A Link in a Doubly Linked List Definition
**
** Purpose:
**	A node object in a doubly linked list with pointers to previous
**	and next objects in the list.  Used in conjunction with Dlist.
*/

#ifndef DLINK_HPP
#include "Dlink.hpp"
#endif /* DLINK_HPP */

#include <iostream.h>

#ifndef CONS_HPP
#include "cons.hpp"
#endif /* CONS_HPP */

#ifndef ADDRLIST_HPP
#include "Addrlist.hpp"
#endif /* ADDRLIST_HPP */

#ifndef ADDRESS_HPP
#include "Address.hpp"
#endif /* ADDRESS_HPP */

#ifndef DICT_HPP
#include "Dict.hpp"
#endif /* DICT_HPP */

Dlink::Dlink(Object* a, Dlink* b, Dlink* c):Slink(a, b) {
	DPRINT("Dlink::Dlink");
	setprev(c);
}

Dlink::~Dlink() {
	DPRINT("Dlink::~Dlink");
	remove();				// remove link from list
}

void	Dlink::setprev(Dlink* a) {
	DPRINT("Dlink::setprev");
	prev = a;
}

Dlink*	Dlink::getprev() {
	DPRINT("Dlink::getprev");
	return(prev);
}

void	Dlink::WriteTo(ostream& s, Addrlist& a) {
	DPRINT("Dlink::WriteTo");

	STARTWRITE(s, a, "Dlink");
	Slink::WriteTo(s, a);			// handle parent
	if (prev && !a.find((void*) prev))	// seen previous before?
		prev->WriteTo(s, a);		// no, write it out
	s << ((long) prev) << " ";
	ENDWRITE(s);
}

void	Dlink::ReadFrom(istream& s, Dict& a) {
	DPRINT("Dlink::ReadFrom");

	STARTREAD(s, a, "Dlink");
	Slink::ReadFrom(s, a);			// process parent

	int	foundobject = 0;
	char	ch = 0,
		itoken[100];

	s >> ch;				// look for '{'
	s.putback(ch);				// just browsing

	if (ch == '{') {			// process previous object
		s >> ch;			// process the '{'

		prev = (Dlink*) check_dict(s);
						// create proper object

		s.putback(ch);			// for object to process

		if (prev) {
			foundobject = 1;
			prev->ReadFrom(s, a);
		}
		else
			return;			// hmmmm
	}

	s >> itoken;				// process previous address
	if (!foundobject) {
		int i = a.find(itoken);
		Ref* ref = (Ref*) a.get(i);
		prev = (Dlink*) ref->getobject();
	}

	ENDREAD(s);
}

void	Dlink::remove() {
	DPRINT("Dlink::remove");
	if (next) 
		((Dlink*) next)->prev = prev;

	if (prev)
		prev->next = next;

	next = prev = 0;
}

Object*	Dlink::CreateMe() {
	DPRINT("Dlink::CreateMe");
	return(new Dlink);
}
