/*
** Dictionary Object Declaration
**
** Purpose:
**	Manage the name to object conversion list.
*/

#ifndef DICT_HPP
#define DICT_HPP

#include <iostream.h>

#ifndef OBJECT_HPP
#include "Object.hpp"
#endif /* OBJECT_HPP */

#ifndef SLIST_HPP
#include "Slist.hpp"
#endif /* SLIST_HPP */

#ifndef REF_HPP
#include "Ref.hpp"
#endif /* REF_HPP */

class Addrlist;

class Dict : public Slist {

public:
	Dict();				// list with no references
	Dict(Ref*);			// list with first entry
	~Dict();				// get rid of list

	int	find(Ref*);		// find reference in list
						// ... (0 not found)
	int	add(Ref*);		// add new reference to list
	int	find(char*);			// find string reference
	int	add(char*, Object*);		// add information to list

	Object*	findobject(istream&);		// convert token to object

	void	WriteTo(ostream&, Addrlist&);
						// linearize the list
	void	ReadFrom(istream&, Dict&);
						// delinearize the list
	Object* CreateMe();			// for delinearization
};

#endif /* DICT_HPP */
