/*
** Dictionary Object Definition
**
** Purpose:
**	Manage the name to object conversion list.
*/

#ifndef DICT_HPP
#include "Dict.hpp"
#endif /* DICT_HPP */

#include <iostream.h>

#ifndef CONS_HPP
#include "cons.hpp"
#endif /* CONS_HPP */

#ifndef ADDRESS_HPP
#include "Address.hpp"
#endif /* ADDRESS_HPP */

#ifndef ADDRLIST_HPP
#include "Addrlist.hpp"
#endif /* ADDRLIST_HPP */

Dict::Dict():Slist() {
	DPRINT("Dict::Dict()");
}

Dict::Dict(Ref* x):Slist(x) {
	DPRINT("Dict::Dict(Ref*)");
}

Dict::~Dict() {
	DPRINT("Dict::~Dict");
}

void	Dict::WriteTo(ostream& s, Addrlist& a) {
	DPRINT("Dict::WriteTo");

	STARTWRITE(s, a, "Dict");
	Slist::WriteTo(s, a);			// handle parent
	ENDWRITE(s);
}

void	Dict::ReadFrom(istream& s, Dict& a) {
	DPRINT("Dict::ReadFrom");

	STARTREAD(s, a, "Dict");
	Slist::ReadFrom(s, a);			// process parent
	ENDREAD(s);
}

int	Dict::find(Ref* adr) {
	DPRINT("Dict::find(Ref*)");
	Ref* current = (Ref*) gethead();
	Ref* last = (Ref*) getlast();

	if (last) {
		int i = 1;

		while (1) {
			if (*current == *adr)
				return(i);
			if (current == last)
				break;
			current = (Ref*) get(++i);
		}
	}
	return(0);
}

int	Dict::add(Ref* adr) {
	DPRINT("Dict::add(Ref*)");

	if (!find(adr)) {			// if not already seen
		(void) Slist::add(adr);		// ...add it to the list
		return(1);
	}
	else
		return(0);
}

Object*	Dict::CreateMe() {
	DPRINT("Dict::CreateMe");
	return(new Dict);
}

int	Dict::find(char* s) {
	DPRINT("Dict::find(char*)");
	Ref* current = (Ref*) gethead();
	Ref* last = (Ref*) getlast();

	if (last) {
		int i = 1;

		while (1) {
			if (*current == s)
				return(i);
			if (current == last)
				break;
			current = (Ref*) get(++i);
		}
	}
	return(0);
}

int	Dict::add(char* s, Object* o) {
	DPRINT("Dict::add(char*, Object*)");
	if (!find(s)) {
		Ref* ref = new Ref(s, o);
		(void) Slist::add(ref);
		return(1);
	}
	else
		return(0);
}

Object*	Dict::findobject(istream& s) {
	DPRINT("Dict::findobject");
	char	token[100];

	s >> token;			// get name to translate
	if (!returntoken(s, token))	// leave it for later processing
		return(0);

	int i = find(token);		// is name in dictionary?

	Ref* ref = (Ref*) get(i);
					// get the reference to name

	Object* obj = ref->getobject();	// get the associated object

	return(obj->CreateMe());	// return new version of object
}
