/*
** Constant Definitions
*/

#ifndef CONS_HPP
#define CONS_HPP

#include <string.h>

#define DEBUG 1

#ifdef DEBUG
#define DPRINT(string)	cerr << string << "\n"
#else
#define DPRINT(string)
#endif

// Stream functions in special functions file
extern char* gettoken(istream&);
extern int returntoken(istream&, char*);

//
// Special WriteTo and ReadFrom macros
//
#define STARTWRITE(st, ad, ty) 					\
	Address* adrptr = new Address(this);			\
	if (!ad.add(adrptr)) delete adrptr;			\
	st << "{ " << ty << " " << ((long) this) << " ";

#define ENDWRITE(st)						\
	st << "}\n";

#define STARTREAD(st, ad, ty)					\
	char c = 0, token[100];					\
	s >> c; if (c != '{') return;				\
	s >> token; if (strcmp(token, ty) != 0) return;		\
	s >> token; ad.add(token, this);

#define ENDREAD(st)						\
	s >> c; s.get(c);

#endif /* CONS_HPP */
