/*
** Address List Object Definition
**
** Purpose:
**	Manage a list of Address objects.
*/

#ifndef ADDRLIST_HPP
#include "Addrlist.hpp"
#endif /* ADDRLIST_HPP */

#include <iostream.h>

#ifndef CONS_HPP
#include "cons.hpp"
#endif /* CONS_HPP */

#ifndef SLINK_HPP
#include "Slink.hpp"
#endif /* SLINK_HPP */

#ifndef DICT_HPP
#include "Dict.hpp"
#endif /* DICT_HPP */

Addrlist::Addrlist():Slist() {
	DPRINT("Addrlist::Addrlist()");
}

Addrlist::Addrlist(Address* x):Slist(x) {
	DPRINT("Addrlist::Addrlist(Address*)");
}

Addrlist::~Addrlist() {
	DPRINT("Addrlist::~Addrlist");
	dclear();
}

void	Addrlist::WriteTo(ostream& s, Addrlist& a) {
	DPRINT("Addrlist::WriteTo");

	STARTWRITE(s, a, "Addrlist");
	Slist::WriteTo(s, a);			// handle parent
	ENDWRITE(s);
}

void	Addrlist::ReadFrom(istream& s, Dict& a) {
	DPRINT("Addrlist::ReadFrom");

	STARTREAD(s, a, "Addrlist");
	Slist::ReadFrom(s, a);			// process parent
	ENDREAD(s);
}

int	Addrlist::find(Address* adr) {
	DPRINT("Addrlist::find");
	Address* current = (Address*) gethead();
	Address* last = (Address*) getlast();

	for (int i = 1; current != last; current = (Address*) get(++i))
		if (*current == *adr)		// Address operator==
			return(i);

	return(0);
}

int	Addrlist::add(Address* adr) {
	DPRINT("Addrlist::add");

	if (!find(adr)) {			// if not already there
		(void) Slist::add(adr);		// ... add it to list
		return(1);
	}
	else
		return(0);
}

Object* Addrlist::CreateMe() {
	DPRINT("Addrlist::CreateMe");
	return(new Addrlist);
}

int	Addrlist::find(void* adr) {
	DPRINT("Addrlist::find(void*)");
	Address* current = (Address*) gethead();
	Address* last = (Address*) getlast();

	for (int i = 1; current != last; current = (Address*) get(++i))
		if (*current == adr)		// Address operator==
			return(i);

	return(0);
}

int	Addrlist::add(void* adr) {
	DPRINT("Addrlist::add(void*)");

	if (!find(adr)) {			// if not already there
		Address* adrptr = new Address(adr);
		(void) add(adrptr);		// ... add it to list
		return(1);
	}
	else
		return(0);
}
