
//-------------------------------------------------------------------------
// Subj: FYI
// From: Mark Howell - 71730,2642
// Note: I posted a message asking how could I use file locking in
// concert with C++ streams.  This is what I came up with.
// I know it's not pretty but this works.
//-------------------------------------------------------------------------

#include <fcntl.h>      // for access flags
#include <sys\stat.h>   // for mode flags
#include <share.h>      // for share flags
#include <IO.h>         // for sopen
#include <errno.h>      // for errno

#include <iostream.h>   // for cerr, cout, cin
#include <fstream.h>    // for ifstream
#include <strstrea.h>   // for strstream


void main(void)
{
   // open the file with deny all access mode

   int handle = sopen("test01.cpp", O_RDONLY, SH_DENYRW, S_IREAD);
   
   if ( handle <= 0 )         // if it didn't open
   {
      if ( errno == EACCES )  // access denied
         cerr << endl
              << "File is being accessed by "
              << "another application." << endl;
      else
         cerr << endl
              << "sopen failed!!!" << endl;
      cerr << "Press enter."    << endl;
      cin.get();
      return;
   }
   
   // associate an ifstream object to the opened file

   ifstream myStream(handle);
   
   if (!myStream)
   {
      cerr << endl
           << "ifstream association failed." << endl
           << "Press enter."                 << endl;
      cin.get();
      close(handle);
      return;
   }
   
   char buffer[80];
   
   // Ok, let's to that stream thing!
   
   while (myStream)
   {
      myStream.getline(buffer,sizeof(buffer));
      if ( myStream.gcount() )
         cout << buffer << endl;
   }

   // Hang on to the file until they press enter.
   // You could start another instance of this pgm
   // to test.  IE: copy the .EXE to another file
   // name and start under another DOS session.
   
   cout << endl << endl
        << "Press enter to exit program." << endl;
   cin.get();
   
   close(handle);
}