/**************************************
 ** SHARED.CPP   - by John Adkins    **
 **                08/10/92          **
 **                                  **
 ** Demos using SHARE with IOSTREAMS **
 **************************************/

/**************************************
 ******  INCLUDES  ********************
 **************************************/

#include <iostream.h>
#include <fstream.h>
#include <conio.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <share.h>

/**************************************
 ******  ROUTINES  ********************
 **************************************/

int getRecNum()
{
  int  number=0;

  while(number<1 || number>5)
  {
    cout << "Which record (1-5)? ";
    cin >> number;
  }
  return(number-1);
}

int chooseAction(int &rec)
{
  int key=0;

  cout << endl << "Choose:  1) Lock a record,  2) Read a record -->";
  while(!key)
  {
    key=getch();
    switch(key)
    {
      case 0:
        getch();
        break;
      case 27: // ESCAPE key
        cout << endl;
        return(0);
      case '1':
      case '2':
        cout << (char)key << endl;
        rec=getRecNum();
        return(key-'0');
      default:
        key=0;
        break;
    }
  }
  return(0);
}

void createDataRecords(fstream &newstream)
{
  newstream.clear();
  newstream.seekg(0);
  for(int buffer=0; buffer<5; buffer++)
  {
    if(lock(newstream.rdbuf()->fd(), buffer*sizeof(int), sizeof(int))==0)
    {
      newstream.write((char*)&buffer, sizeof(int));
      unlock(newstream.rdbuf()->fd(), buffer*sizeof(int), sizeof(int));
    }
    else
    {
      cerr << "Error locking record #" << buffer << "." << endl;
      newstream.clear();
    }
  }
}

void main()
{
  int           handle;  // file handle of shared file

  handle=sopen("SHARED.DAT",O_CREAT|O_RDWR|O_BINARY,SH_DENYNONE,S_IWRITE|S_IREAD);
  if(handle>=0)
  {
    fstream   shared(handle);
    int       buffer;

    if(shared.read((char *)&buffer, sizeof(int)).eof())
    {
      cout << "Empty file encountered, creating records..." << endl;
      createDataRecords(shared);
    }

    int record;
    int action;
    while(action=chooseAction(record))
    {
      switch(action)
      {
        case 1: // Lock a record

          if(lock(handle,record*sizeof(int),sizeof(int))==0)
          {
            cout << "Record #" << record+1 << " has been locked." << endl;
            cout << "Press any key to continue...";
            while(!kbhit());
            if(!getch()) getch();
            cout << endl;
            unlock(handle,record*sizeof(int),sizeof(int));
          }
          else
          {
            cerr << "Unable to lock record #" << record+1 << "." << endl;
          }
          break;

        case 2: // Read a record

          shared.seekg(record*sizeof(int));
          shared.clear();
          if(shared.read((char*)&buffer,sizeof(int)))
          {
            cout << "Record #" << record+1 << " has the value "
                 << buffer << "." << endl;
          }
          else
          {
            shared.clear();
            cerr << "Unable to read record #" << record+1 << "." << endl;
          }
          break;
      }
    }
  }
  else
    cerr << "Unable to sopen SHARED.DAT file." << endl;
}

/**************************************
 ******  END OF SHARED.CPP  ***********
 **************************************/


