
// Set.hpp - Copyright 6/24/92 Scott Diorio, Impeccable Arts


// REVISION HISTORY
//
// 9/20/93 Speeded up Put and Get operations
//
// 7/31/94 Added In(char *) function for string searches
//         Fixed Copy constructor bug that caused NULL pointer Assignment (oops)

#ifndef _SETCLASS.HPP_
#define _SETCLASS.HPP_


#define BITON  0xFF
#define BITOFF 0x00

enum BOOLEAN {FALSE,TRUE};

class ostream;
class Set
{
  private:
		int err;

	protected:

		unsigned bufsize;
		unsigned min,max;
		char *buf;
    int pmode;

		int getnextrange(char *str,int &start, int &stop);
		void Put( unsigned, unsigned char );
		BOOLEAN Get( unsigned );

	public:
		Set(const Set& S, int num, unsigned char mode);
		Set(void);
		Set(char *str);
		Set(const char *str);
		Set(unsigned, unsigned, unsigned char );
		Set(const Set& );
		~Set(void);
		int bad(void);

		BOOLEAN In(unsigned);
		BOOLEAN In(char *str);
		BOOLEAN In(Set &);

		void Filter(char *);
    void Clear(void);
		Set& operator=(char *);

		void operator -=(unsigned);
		void operator +=(unsigned);

		Set& operator -=(Set &);
		Set& operator +=(Set &);
		Set& operator *=(Set &);
		Set& operator ^=(Set &);

		Set& operator= (Set &);
		Set  operator- (Set &);
		Set  operator+ (Set &);
		Set  operator* (Set &);
		Set  operator^ (Set &);

		void printMode(int);

		friend Set operator! (Set& ); // Complement operator
		friend ostream &operator << (ostream&, Set &);

		friend Set operator+(const Set&, int);
		friend Set operator-(const Set&, int);

		friend BOOLEAN operator == (Set& A,Set &B);
		friend BOOLEAN operator != (Set& A,Set &B );

		friend BOOLEAN operator <  (Set &A, Set &B);
		friend BOOLEAN operator <= (Set &A, Set &B);
		friend BOOLEAN operator >  (Set &A, Set &B);
		friend BOOLEAN operator >= (Set &A, Set &B);

};


#endif
