
// Set suite for SET class
// Copyright 1994 Impeccable Arts

void test1(void);
void test2(void);
void test3(void);
void test4(void);
void test5(void);

#include <string.h>
#include <iostream.h>
#include <iomanip.h>
#include "set.hpp"

void main(void)
{
	test1();
	test2();
	test3();
	test4();
	test5();
}

// Character Sets - with a couple of contructor examples

void test1(void)
{

  Set Simple( "abcd");
  Set Vowels( "aeiou");
  Set Consonants( "bcdfghjklmnpqrstvwxyz");
  Set AlphaNumeric( "0..9,a..z,A..Z");

  Set A( "0123456,.,,,A..Z,a..z");

	for(int z=29;z<255;z++)
		{
			cout << z << "   " << (char)z << "  ";
			if( A.In(z) )
				cout << "ON";
			cout << endl;
		}

  char tmp[20];
  Set Letters("a..z,:\\.A..Z");

  strcpy(tmp,"c:\\filename.dat");
  cout << tmp;
  if( Letters.In(tmp) )
    cout << " PASS\n";
  else
    cout << " FAIL\n";

	strcpy(tmp,"c:\\tmp.d$at");
	cout << tmp;
	if( Letters.In(tmp) )
		cout << " PASS\n";
	else
		cout << " FAIL\n";

	// filter out unwanted characters
	cout << tmp << endl;
	Letters.Filter(tmp);
	cout << tmp << endl;
}


////////////////////////////////////////////////////////////////////////
// Set Mathematics test

void test2(void)
{
	int t;
	int q;

	Set a( 0,45, BITON);
	Set b( 50,65, BITON);
	Set c;

	// test +, +=
	cout << "a\n" << a << endl;
	cout << "b\n" << b << endl;
	cout << "c\n" << c << endl;
	a+=b;
	c=a;
	cout << "a\n" << a << endl;
	cout << "b\n" << b << endl;
	cout << "c\n" << c << endl;
	a=a+b;
	cout << "a\n" << a << endl;
	cout << "b\n" << b << endl;
	cout << "c\n" << c << endl;

	c="0..9";
	cout << "c\n" << c << endl;



	// create sets A-G
	Set A( 0,45, BITON);
	Set B( 0,25, BITON);
	Set C;
	Set D( 30,50, BITON);
	Set E(10,20,BITON);
	Set F(15,30,BITON);
	Set G(0,50,BITOFF);

	cout << "A\n" << A << endl;
	cout << "B\n" << B << endl;
	cout << "C\n" << C << endl;
	cout << "D\n" << D << endl;
	cout << "E\n" << E << endl;
	cout << "F\n" << F << endl;
	cout << "G\n" << G << endl;

	// Union of 2 sets
	C=A+B;
	cout << "A\n" << A << endl;
	cout << "B\n" << B << endl;
	cout << "C=A+B\n" << C << endl;

	C=A+D;
	cout << "A\n" << A << endl;
	cout << "D\n" << D << endl;
	cout << "C=A+D\n" << C << endl;

	// Difference of 2 sets
	C=A-B;
	cout << "A\n" << A << endl;
	cout << "B\n" << B << endl;
	cout << "C=A-B\n" << C << endl;

	C=A-D;
	cout << "A\n" << A << endl;
	cout << "D\n" << D << endl;
	cout << "C=A-D\n" << C << endl;

	// test -=
	cout << "A\n" << A << endl;
	cout << "B\n" << B << endl;
	A-=B;
	cout << "A\n" << A << endl;
	cout << "B\n" << B << endl;

	// test +=
	A+=B;
	cout << "A\n" << A << endl;
	cout << "B\n" << B << endl;

	// Set assignment
	A=B;
	cout << "A\n" << A << endl;
	cout << "B\n" << B << endl;

  // Union
	B=C+D;
	cout << "C\n" << C << endl;
	cout << "D\n" << D << endl;
	cout << "B=C+D\n" << B << endl;

  // difference
	B=C-D;
	cout << "C\n" << C << endl;
	cout << "D\n" << D << endl;
	cout << "B=C-D\n" << B << endl;


  // intersection of 2 sets
	G=E*F;
	cout << "E\n" << E << endl;
	cout << "F\n" << F << endl;
	cout << "G=E*F\n" << G << endl;

  // complement of a set
	G=!F;
	cout << "F\n" << F << endl;
	cout << "G=!F\n" << G << endl;

	Set d(0,35,BITON);
	Set e(25,50,BITON);
	cout << "d\n" << d << endl;
	cout << "e\n" << e << endl;

	a=d^e;
	cout << "a\n" << a << endl;




	// Set Equality
	Set H("A..D");
	Set I("A..B");
	Set J("A..D");
	Set K("B..E");

	cout << "H\n" << H << endl;
	cout << "I\n" << I << endl;
	cout << "J\n" << J << endl;
	cout << "K\n" << K << endl;

	// Test Equality
	if(H==I)
		cout << "H = I\n";
	else
		cout <<  "H != I\n";

	if(H==J)
		cout <<  "H = J\n";
	else
		cout <<  "H != J\n";

	// Test Inequality
	if(H!=I)
		cout <<  "H != I\n";
	else
		cout << "H = I\n";

	if(H!=J)
		cout <<  "H != J\n";
	else
		cout <<  "H = J\n";

	// Test <, <=, >, >=
	cout << "H\n" << H << endl;
	cout << "I\n" << I << endl;
	if(H<I)
		cout <<  "H < I\n";
	else
		cout << "H >= I\n";
	if(H<=I)
		cout <<  "H <= I\n";
	else
		cout << "H > I\n";
	if(H>I)
		cout <<  "H > I\n";
	else
		cout <<  "H <= I\n";
	if(H>=I)
		cout <<  "H >= I\n";
	else
		cout <<  "H < I\n";

	// Test Sub-set (IN)
	if( H.In(I) )
		cout << "I is IN H\n";
	else
		cout << "I is NOT IN H\n";

	if( J.In(K) )
		cout << "K is IN J\n";
	else
		cout << "K is NOT IN J\n";


	cout <<"\n\n";
}

//////////////////////////////////////////////////////////////////////////
// Single bit minipulations test

void test3(void)
{
  // Set 0-55
	Set T(0,55,BITOFF);
	cout << T << endl;

  // Take sets compliment
	T= !T;
	cout << T << endl;

  // turn off elements 1,2,3,4,5,6,7,8,9
	T=T-1-2-3-4-5-6-7-8-9;
	cout << T << endl;

  // turn on elements 3,6,9
  T=T+3+6+9;
	cout << T << endl;

  // loop through set testing members 1-10
	for(int t=0; t<=10; t++ )
		{
			if( T.In(t) )
				cout << t << " is in the set \n";
			else
				cout << t << " is not in the set \n";
		}

  // take sets complement
	T= !T;
	cout << T;

  // turn on set members 2,4,6,8,10
	T=T+2+4+6+8+10;
	cout << T;

  // turn off set member 6
	T=T-6;
	cout << T;

  // turn off set member 8
	T=T-8;
	cout << T;

  // loop through set testing members 1-10
	for(t=0; t<=10; t++ )
		{
			if( T.In(t) )
				cout << t << " is in the set \n";
			else
				cout << t << " is not in the set \n";
		}


  // clear all set members
  T.Clear();
	cout << T << endl;


  // Instead of Using ODD and EVEN as an example here, anything can
  // be substituted. Fibonacci or Prime Numbers, etc.

  // turn ODD members ON
	cout << "ODD members ON\n";
	for( t=1; t<=55; t+=2 )
		T+=t;
	cout << T << endl;

  // turn ALL members ON
	cout << "ALL members ON\n";
	for( t=0; t<=55; t+=2 )
		T+=t;
	cout << T << endl;

  // turn ODD members OFF
	cout << "EVEN members ON\n";
  for( t=1; t<=55; t+=2 )
	  T-=t;
	cout << T << endl;

  // turn EVEN members OFF
  cout << "ALL members OFF\n";
	for( t=0; t<=55; t+=2 )
		T-=t;
	cout << T << endl;
}

////////////////////////////////////////////////////////////////////////
// speed test - Turn a bit ON and OFF 100,000 times

void test4(void)
{
  cout << "Turning 1 bit ON and OFF 100,000 times\n";

	Set A(0,75,BITON);

	cout << A;

	for(long t=0;t<100000;t++)
		{
      A+=15;
		  A-=15;
    }
	cout << A;
}


/////////////////////////////////////////////////////////////////////////
// Large set test

void test5(void)
{
  cout << "Create/Manipulate LARGE set\n";
	Set L(0,5000,BITOFF);
  cout << L;
  for(long l=0;l<=5000;l++)
		L+=l;
  cout << L;
}

// Routine used for debugging and demo purposes
ostream &operator << (ostream &os, Set &S)
{
	int q;
	os << "Range " << setw(5) << S.min << ".."
                 << setw(5) << S.max << "  ";
  if(S.pmode)
    {
			for( q=0; q<S.min; q++ )
    		os << "X";
    }
  if(S.max)
	  for( q=S.min; q<=S.max; q++ )
		  os << S.Get(q);
	os << "\n";
	return( os );
}

