// ObjectWindows - (C) Copyright 1991 by Borland International

// This program shows how to use a button with 3 user-defined bitmaps
// from a Window rather than a dialog using the BBM_SETBITS message.
// Enjoy.  Written by Mike Redding.


#include <owl.h>
#include <window.h>
#include <string.h>
#include <bwcc.h>
#include <bbutton.h>

const int CM_WINDOW = 100;

enum TSubWinType { SW_CHILD, SW_POPPARENT, SW_POPNOPARENT };

class TSubWindow : public TWindow
{
private:
	TSubWinType SubWinType;
public:
	TSubWindow( PTWindowsObject AParent, TSubWinType ASubWinType );
	virtual ~TSubWindow( void );
	void SetupWindow();
	virtual void Paint( HDC, PAINTSTRUCT& PaintStruct );
};

typedef TSubWindow* PSubWindow;

class TMainWindow : public TWindow
{
public:
	TMainWindow( LPSTR ATitle );
	void ShowSubWindow( PTWindowsObject AParent, TSubWinType ASubWinType );
	virtual void WMInitMenu( TMessage& Msg ) = [ WM_FIRST + WM_INITMENU ];
	virtual void CMChild( TMessage& Msg ) = [ CM_FIRST + CM_WINDOW + SW_CHILD ];
	virtual void CMPopParent( TMessage& Msg ) = [ CM_FIRST + CM_WINDOW + SW_POPPARENT ];
	virtual void CMPopNoParent( TMessage& Msg ) = [ CM_FIRST + CM_WINDOW + SW_POPNOPARENT ];
};

typedef TMainWindow* PMainWindow;

class TPopupApp : public TApplication
{
public:
	TPopupApp(LPSTR name, HANDLE hInstance, HANDLE hPrevInstance,
		  LPSTR lpCmd, int nCmdShow)
		  : TApplication(name, hInstance, hPrevInstance,
				 lpCmd, nCmdShow) {};
	virtual void InitMainWindow( void );
};

PSubWindow SubWinPtr[] = { NULL, NULL, NULL };

LPSTR SubWinTitle[] = { "Child Window", "Popup with Parent",
	"Popup without Parent" };

long SubWinStyle[] = {
    WS_CHILD | WS_OVERLAPPEDWINDOW | WS_VISIBLE,
    WS_POPUP | WS_OVERLAPPEDWINDOW | WS_VISIBLE,
    WS_POPUP | WS_OVERLAPPEDWINDOW | WS_VISIBLE };

POINT SubWinPos[] = { { 10, 10 }, { 34, 72 }, { 54, 92 } };


TSubWindow::TSubWindow( PTWindowsObject AParent, TSubWinType ASubWinType ) :
	TWindow( AParent, SubWinTitle[ ASubWinType ] )
{
	TBButton *MyBtn;

	Attr.Style = SubWinStyle[ ASubWinType ];
	Attr.X = SubWinPos[ ASubWinType ].x;
	Attr.Y = SubWinPos[ ASubWinType ].y;
	Attr.W = 300;
	Attr.H = 150;
	SubWinType = ASubWinType;

}

void TSubWindow::SetupWindow()
{
   TBButton *btn;
   HBITMAP hBits[3];


   btn = new TBButton(this,10,"",10,10,50,50,FALSE);
   TWindow::SetupWindow();


//
//  THIS LOADS THE 3 BITMAPS INTO THE HBITS ARRAY
//

   hBits[0] = LoadBitmap(GetApplication()->hInstance,"REDBMP");
   hBits[1] = LoadBitmap(GetApplication()->hInstance,"bluebmp");
   hBits[2] = LoadBitmap(GetApplication()->hInstance,"greenbmp");


//
//  THIS TELLS THE BUTTON TO USE THESE BITMAPS FOR ITS 3 STATES
//

   SendMessage( btn->HWindow, BBM_SETBITS, 0, (LONG) (LPSTR)
	 hBits);

}


TSubWindow::~TSubWindow( void )
{
	SubWinPtr[ SubWinType ] = NULL;
}

void TSubWindow::Paint( HDC, PAINTSTRUCT& )
{
}

TMainWindow::TMainWindow( LPSTR ATitle ) : TWindow( NULL, ATitle )
{
	Attr.X = 0;
	Attr.Y = 0;
	Attr.W = 400;
	Attr.H = 215;
	AssignMenu( "COMMANDS" );
}

void TMainWindow::ShowSubWindow( PTWindowsObject AParent,
	TSubWinType ASubWinType )
{
	if ( SubWinPtr[ ASubWinType ] == NULL )
		SubWinPtr[ ASubWinType ] = PSubWindow(
			GetApplication()->MakeWindow(
				new TSubWindow( AParent, ASubWinType) ) );
	else
		SetFocus( SubWinPtr[ ASubWinType ]->HWindow );
}

void TMainWindow::WMInitMenu( TMessage& )
{
	WORD MenuState;

	for ( int i = SW_CHILD; i <= SW_POPNOPARENT; i++ )
	{
		if ( SubWinPtr[i] == NULL )
			MenuState = MF_UNCHECKED;
		else
			MenuState = MF_CHECKED;
		CheckMenuItem( GetMenu(HWindow), CM_WINDOW + i, MenuState );
	}
}

void TMainWindow::CMChild( TMessage& )
{
	ShowSubWindow( this, SW_CHILD );
}

void TMainWindow::CMPopParent( TMessage& )
{
	ShowSubWindow( this, SW_POPPARENT );
}

void TMainWindow::CMPopNoParent( TMessage& )
{
	ShowSubWindow( NULL, SW_POPNOPARENT );
}

void TPopupApp::InitMainWindow( void )
{
	MainWindow = new TMainWindow( "Parent Window" );
}

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
		   LPSTR lpCmd, int nCmdShow)
{

// THIS CALL IS NECESSARY TO LOAD BWCC.DLL AT RUNTIME

	BWCCGetVersion();

	TPopupApp PopupApp("Popup", hInstance, hPrevInstance,
			   lpCmd, nCmdShow);
	PopupApp.Run();
	return ( PopupApp.Status );
}
