/*
 *
 *  input.c   - demonstration file for displaying and using an input screen
 *		using SCREDIT.
 *
 *
 *
 */
#include    "conio.h"
#include    "time.h"
#include    "mem.h"
#include    "string.h"

#include    "scrdemo.h"     /* Header file for SCREDIT */
#include    "input.h"       /* Header file for input.sbj */
#include    "getkey.h"      /* Header file for getkey */

void main(void)
{
    struct sc_input scr;	/* define variable scr for the screen structure */
    void far *offset;		/* defines field where cursor should be placed */
    int     ret;		/* return from edit_input_fields */
    int     done = FALSE;

    clrscr();			/* clear the screen */
    setmem(&scr, sizeof(scr), 0);   /* clear out scr */
    /*
     * scr fields may be initialized prior to calling SCREDIT.
     *	this allows using default values, retrieving a record
     *	from a database and displaying the data for editing, etc.
     */

    time(&scr.lst_pmt_date);
    scr.lst_pmt_amt = 57567L;	    /* payment is 575.67, as field is a 'money' type,
				     *	will have implied decimals as defined by the
				     *	variable num_decimals.
				     */

    /* since this demo does not contain a database, we will initialize the
     *	fields using strcpy, etc.
     */
    strcpy(scr.name, "Underwood, Tim");
    strcpy(scr.address1, "1719 S. Shiloh");
    strcpy(scr.city, "Wichita");
    strcpy(scr.state, "KS");
    strcpy(scr.zip, "67207");

    disp_prompts(sc_input_pmt);     /* display main screen */
    offset = &scr.name; 	    /* initialize the offset to start in the
				     * name field
				     */
    do {
	/*  call the edit routine,  note that it will also display data
	 *   already in the fields, then allow editing.
	 */
	ret = edit_input_fields(sc_input_inp, &scr, &offset);
	switch (ret) {	    /* what key did the user exit with? */

	    case PGDN  :    /* Page Down */
		/* get next customer and edit */
		break;

	    case PGUP  :    /* Page Up */
		/* get previous customer and edit */
		break;

	    case ENTER :    /* ENTER key */
		/*
		 * here we can do some checking of the user's input,
		 *  or whatever else you may want to do.
		 *  We won't actually do any checking, but will simply
		 *   'drop' through tothe ESC case to clear the screen
		 *   and exit.
		 */

	    case ESC :	    /* quit/abort key? */
		undisp_prompts(sc_input_pmt);
		done = TRUE;
		break;
	}
    } while (!done);

    printf("          Name: %s\n", scr.name);
    printf("     Address 1: %s\n", scr.address1);
    printf("     Address 2: %s\n", scr.address2);
    printf("City/State/Zip: %-20s/%-2s/%s\n", scr.city, scr.state, scr.zip);

}
