/******************************************************************************

	Module: window.c

	 Title: Window Demonstration

   Description: Window tutorial demonstration

 ******************************************************************************/
#include    "conio.h"
#include    "mem.h"
#include    "scredit.h"
#include    "winhelp.h"

char far *barmenu[]={"File",
		     "Window",
		     "Block",
		     "Print",
		     "Exit",
		     ""
};

char far *file_menu[] = {"Load",
			"Save",
			"Read",
			"OS shell",
			"Write",
			""};

char far *window_menu[] = {"Grow",
			"Shrink",
			"Close",
			"Move",
			""};

char far *block_menu[] = {"Move",
			  "Delete",
			  "Upper",
			  "Lower",
			  ""};

char far *print_menu[] = {"All",
			 "Initialize",
			 "Settings",
			 ""};

char far *exit_menu[] = {"Abort",
			 "Continue",
			 ""};

int	old_cursor;
WINDO	old_screen = {UNINIT};

#pragma        page
/******************************************************************************
    Name                initialize
  
    Description 	Initializes WINDOW.EXE
  
    Returns             void
 ******************************************************************************/
void initialize(void)
{
    old_cursor = get_cursor_type();	/* get and save the old cursor type */
  
    /*	set up a window to save the entire screen */
    old_screen.row      = 1;
    old_screen.col      = 1;
    old_screen.num_rows = 25;
    old_screen.num_cols = 80;
    old_screen.txt_attr = 0x07;
    old_screen.bdr_type = No_Border;
    old_screen.bdr_attr = 0x07;
    setmem(old_screen.title, sizeof(old_screen.title), 0);
    make_window(&old_screen);
}

#pragma        page
/******************************************************************************
    Name                deinit
  
    Description 	Deinitializes WINDOW.EXE
  
    Returns             void
 ******************************************************************************/
static void deinit(void)
{
    /* restore the old screen */
    remove_window(&old_screen);
    setcursor(old_cursor);	    /* reset the old cursor value */
}

#pragma 	page
/******************************************************************************

   Name 		file

   Description		file selection menu

   Returns		int - key pressed by user to exit pulldown menu

 ******************************************************************************/
int file(void)
{
    PULLDOWN f = {UNINIT, 2, 2, attr(BLACK,CYAN),attr(BLACK,CYAN),
	attr(BLACK,LIGHTGRAY), attr(RED,CYAN), attr(RED,LIGHTGRAY), Single_Border,
	No_Enumerate, TRUE, TRUE, (char far *)"", file_menu};
    int             ret;
  
    do {
	ret = make_pulldown_menu(&f);
        switch(ret) {
	    case _RIGHT :
	    case _LEFT	:
            case ESC:
		remove_pulldown_menu(&f);
		return(ret);
  
            case 0  :
            case 1  :
            case 2  :
            case 3  :
                break;
        } /* end of switch */
  
    } while (1 == 1);
}

#pragma 	page
/******************************************************************************

   Name 		window_sel

   Description		window selection menu

   Returns		int - key pressed by user to exit pulldown menu

 ******************************************************************************/
int window_sel(void)
{
    PULLDOWN f = {UNINIT, 2, 9, attr(BLACK,CYAN),attr(BLACK,CYAN),
	attr(BLACK,LIGHTGRAY), attr(RED,CYAN), attr(RED,LIGHTGRAY), Single_Border,
	No_Enumerate, TRUE, TRUE, (char far *)"", window_menu};
    int             ret;
  
    do {
	ret = make_pulldown_menu(&f);
        switch(ret) {
	    case _RIGHT :
	    case _LEFT	:
            case ESC:
		remove_pulldown_menu(&f);
		return(ret);
  
            case 0  :
            case 1  :
            case 2  :
            case 3  :
                break;
        } /* end of switch */
  
    } while (1 == 1);
}

#pragma 	page
/******************************************************************************

   Name 		block

   Description		block selection menu

   Returns		int - key pressed by user to exit pulldown menu

 ******************************************************************************/
int block(void)
{
    PULLDOWN f = {UNINIT, 2, 17, attr(BLACK,CYAN),attr(BLACK,CYAN),
	attr(BLACK,LIGHTGRAY), attr(RED,CYAN), attr(RED,LIGHTGRAY), Single_Border,
	No_Enumerate, TRUE, TRUE, (char far *)"", block_menu};
    int             ret;
  
    do {
	ret = make_pulldown_menu(&f);
        switch(ret) {
	    case _RIGHT :
	    case _LEFT	:
            case ESC:
		remove_pulldown_menu(&f);
		return(ret);
  
            case 0  :
            case 1  :
            case 2  :
            case 3  :
                break;
        } /* end of switch */
  
    } while (1 == 1);
}

#pragma 	page
/******************************************************************************

   Name 		print

   Description		print selection menu

   Returns		int - key pressed by user to exit pulldown menu

 ******************************************************************************/
int print(void)
{
    PULLDOWN f = {UNINIT, 2, 24, attr(BLACK,CYAN),attr(BLACK,CYAN),
	attr(BLACK,LIGHTGRAY), attr(RED,CYAN), attr(RED,LIGHTGRAY), Single_Border,
	No_Enumerate, TRUE, TRUE, (char far *)"", print_menu};
    int             ret;
  
    do {
	ret = make_pulldown_menu(&f);
        switch(ret) {
	    case _RIGHT :
	    case _LEFT	:
            case ESC:
		remove_pulldown_menu(&f);
		return(ret);
  
            case 0  :
            case 1  :
            case 2  :
            case 3  :
                break;
        } /* end of switch */
  
    } while (1 == 1);
}

#pragma 	page
/******************************************************************************

   Name 		exit_sel

   Description		exit_sel selection menu

   Returns		int - key pressed by user to exit pulldown menu

 ******************************************************************************/
int exit_sel(void)
{
    PULLDOWN f = {UNINIT, 2, 31, attr(BLACK,CYAN),attr(BLACK,CYAN),
	attr(BLACK,LIGHTGRAY), attr(RED,CYAN), attr(RED,LIGHTGRAY), Single_Border,
	No_Enumerate, TRUE, TRUE, (char far *)"", exit_menu};
    int             ret;
  
    do {
	ret = make_pulldown_menu(&f);
        switch(ret) {
	    case _RIGHT :
	    case _LEFT	:
	    case 0 :
	    case 1 :
            case ESC:
		remove_pulldown_menu(&f);
		return(ret);
        } /* end of switch */
  
    } while (1 == 1);
}

#pragma 	page
/******************************************************************************

   Name 		help

   Description		Provides a help screen

   Returns		void

 ******************************************************************************/
void help(void)
{
    WINDO far	*xwin;

    xwin = disp_prompts(sc_winhelp_pmt, NULL);
    while (getkey(0) != ESC);
    undisp_prompts(sc_winhelp_pmt, xwin);
}

#pragma        page
/******************************************************************************
    Name                menu
  
    Parms               char *exename
  
    Description         The Main barmenu
  
    Returns             void
 ******************************************************************************/
void menu(void)
{
    POPBAR   menu = {UNINIT,attr(BLACK, CYAN), attr(BLACK,CYAN),
			attr(BLACK,LIGHTGRAY), attr(RED,CYAN),
			attr(RED,LIGHTGRAY), TRUE, TRUE, barmenu};
    int     ret, orig_value;
  
    orig_value = ret = make_bar_menu(&menu, 1);
    do {
	switch(ret) {
	    case 0  :
		ret = file();
		if (ret == _LEFT) {
		    menu.cur_select = 4;
		    paint_bar_menu_select(&menu, 0);
		    break;
		}
		if (ret != _RIGHT)
		    break;

	    case 1  :
		menu.cur_select = 1;
		paint_bar_menu_select(&menu, 0);
		ret = window_sel();
		if (ret == _LEFT) {
		    menu.cur_select = 0;
		    paint_bar_menu_select(&menu, 0);
		    break;
		}
		if (ret != _RIGHT)
		    break;

	    case 2  :
		menu.cur_select = 2;
		paint_bar_menu_select(&menu, 0);
		ret = block();
		if (ret == _LEFT) {
		    menu.cur_select = 1;
		    paint_bar_menu_select(&menu, 0);
		    break;
		}
		if (ret != _RIGHT)
		    break;

	    case 3  :
		menu.cur_select = 3;
		paint_bar_menu_select(&menu, 0);
		ret = print();
		paint_bar_menu_select(&menu, 0);
		if (ret == _LEFT) {
		    menu.cur_select = 2;
		    paint_bar_menu_select(&menu, 0);
		    break;
		}
		if (ret != _RIGHT)
		    break;

	    case F1 :
		help();
		break;

	    case ESC:
		remove_bar_menu(&menu);
		return;

	    case 4  :
		menu.cur_select = 4;
		paint_bar_menu_select(&menu, 0);
		ret = exit_sel();
		paint_bar_menu_select(&menu, 0);
		if (ret == _LEFT) {
		    menu.cur_select = 3;
		    paint_bar_menu_select(&menu, 0);
		    break;
		}
		if (ret == 0) {
		    remove_bar_menu(&menu);
		    return;
		}
		else
		    break;
	} /* end of switch */

    } while (1 == 1);
}

#pragma 	page
/******************************************************************************

   Name 		main

   Description		Gets it rolling

   Returns		void

 ******************************************************************************/
void main(void)
{
    initialize();

    menu();

    deinit();
}
