/******************************************************************************
*
*       Module: sets.h
*
*  Description: Pascal-like set routines for 'C'
*
*  $include$="sdoc.glb" <--- This is for SOURCEDOC
*
*******************************************************************************/
#ifndef TRUE
#define TRUE        1
#define FALSE       0
#endif

#ifndef     __SETS
#define     __SETS
#include    <mem.h>


/******************************************************************************
*$NAME$
*clear_set
*$1$
*Summary
*
*    #include    "$./FL$.H"
*
*    #define clear_set(set, setsize);
*
*    set;           Address of set (an array of characters)
*    setsize;       Size of set in bytes
*
*Description         $.(function is defined in /FL/EXT, ~line /LN )$
*
*    Defined function to clear a set to NULLs
*
*Return value
*
*    None.
*
*$END$$SKIP START$
*******************************************************************************/
#define clear_set(set, setsize)     setmem(set, setsize, 0)


/******************************************************************************
*$NAME$
*setbit
*$1$
*Summary
*
*    #include    "$./FL$.H"
*
*    #define setbit(set, set_bit);
*
*    set;           Address of set (An array of characters)
*    set_bit;       Integer value of bit to set
*
*Description         $.(function is defined in /FL/EXT, ~line /LN )$
*
*    Defined function to sets a bit in the set.
*    No bounds checking is performed.
*
*Return value
*
*    None.
*
*$END$$SKIP START$
*******************************************************************************/
#define setbit(set, set_bit)        (unsigned char)set[(set_bit / 8)] |= (unsigned char)(0x80 >> (set_bit % 8))


/******************************************************************************
*$NAME$
*inset
*$1$
*Summary
*
*    #include    "$./FL$.H"
*
*    #define inset(set, check_bit);
*
*    set;           Address of set (an array of characters)
*    check_bit;     Integer value of bit to test
*
*Description         $.(function is defined in /FL/EXT, ~line /LN )$
*
*    Defined function to see if a bit is set.  No bounds checking is done.
*
*Return value
*
*    TRUE if bit is set, FALSE otherwise
*
*$END$$SKIP START$
*******************************************************************************/
#define inset(set, check_bit)       (((unsigned char)set[check_bit / 8] & (unsigned char)(0x80 >> (check_bit % 8))) ? TRUE : FALSE)


/******************************************************************************
*$NAME$
*clearbit
*$1$
*Summary
*
*    #include    "$./FL$.H"
*
*    #define clearbit(set, clear_bit);
*
*    set;           Address of set (an array of characters)
*    clear_bit;     Integer value of bit to test
*
*Description         $.(function is defined in /FL/EXT, ~line /LN )$
*
*    Defined function to reset(clear) a bit in a set.  No bounds checking
*    is performed.
*
*Return value
*
*    #define
*
*$END$$SKIP START$
*******************************************************************************/
#define clearbit(set, clear_bit)    ((unsigned char)set[clear_bit / 8] ^= (unsigned char)(0x80 >> (clear_bit % 8)))

/*
**  Adds set1 to set2, and puts result into result, sets may be
**   of different sizes.
*/
void add_sets(void *set1, int set1size, void *set2, int set2size, void *result, int result_size);

/*
**  XORs set1 against set2, and puts result into result, sets may be
**   of different sizes.
*/
void sub_sets(void *set1, int set1size, void *set2, int set2size, void *result, int result_size);

#endif
