/******************************************************************************
*
*       Module: bcd.h
*
*  Description: Header file for bcd.c
*
*******************************************************************************/
#ifndef     TRUE
#define     TRUE            1
#define     FALSE           0
#endif

#ifndef     __BCDNUM__
#define     __BCDNUM__

/*
**  Typedefs for packed BCD and unpacked BCD
*/
typedef char BCD_NUM[10];
typedef char UNPACK_BCD[20];

/*
**  Defines to use with bcd_compare
**
*/
#define     BCD_LT          0x0000      /* bcd1 <  bcd2 */
#define     BCD_LE          0x0001      /* bcd1 <= bcd2 */
#define     BCD_GT          0x0002      /* bcd1 >  bcd2 */
#define     BCD_GE          0x0004      /* bcd1 >= bcd2 */
#define     BCD_EQ          0x0008      /* bcd1 == bcd2 */
#define     BCD_NE          0x0010      /* bcd1 != bcd2 */
#define     BCD_ABS         0x0100      /* abs(bcd1) compare abs(bcd2) */
#define     BCD_OPMASK      0x00FF      /* mask to mask out BCD_ABS */

/*
**  Defines to set signs in packed/unpacked BCD, determine if sign
**      is negative, or positive, etc.
*/
#define set_ubcd_positive(bcd)      (bcd[sizeof(UNPACK_BCD) - 1] = (bcd[sizeof(UNPACK_BCD) - 1] & 0xF0) | 0x0F)
#define set_ubcd_negative(bcd)      (bcd[sizeof(UNPACK_BCD) - 1] = (bcd[sizeof(UNPACK_BCD) - 1] & 0xF0) | 0x0D)
#define clear_ubcd_sign(bcd)        (bcd[sizeof(UNPACK_BCD) - 1] = (bcd[sizeof(UNPACK_BCD) - 1] & 0xF0))
#define get_bcd_sign(bcd)           (*((char far *)((char far *)bcd + 9)) & 0x0F)
#define set_bcd_sign(bcd,sign)      (*((char far *)bcd + 9) = (*((char far *)bcd + 9) & 0xF0) | sign)
#define toggle_bcd_sign(bcd)        (set_bcd_sign(bcd, (get_bcd_sign(bcd) == 0x0F ? 0x0D : 0x0F) ))
#define isbcd_pos(bcd)              ((*((char far *)((char far *)bcd + 9)) & 0x0F) == 0x0F)
#define isbcd_neg(bcd)              ((*((char far *)((char far *)bcd + 9)) & 0x0F) == 0x0D)


/*
**  BCD to string/string to BCD conversion routines
*/
char *bcd_tostr(BCD_NUM far *bcd, char *str);
BCD_NUM far *str_tobcd(BCD_NUM far *bcd, char *str);
char *bcd_tomoney(BCD_NUM far *bcd, int num_decimals, char *str);
BCD_NUM far *money_tobcd(BCD_NUM far *bcd, int num_decimals, char *str);

/*
**  Conversion routines to pack/unpack unpacked/packed BCD numbers
*/
BCD_NUM far *unpack_to_packbcd(UNPACK_BCD far *ubcd, BCD_NUM far *bcd);
UNPACK_BCD far *pack_to_unpackbcd(UNPACK_BCD far *ubcd, BCD_NUM far *bcd);

/*
**  Conversion routines from int/long to packed BCD
*/
BCD_NUM far *int_to_bcd(int value, BCD_NUM far *bcd);
BCD_NUM far *uint_to_bcd(unsigned int value, BCD_NUM far *bcd);
BCD_NUM far *long_to_bcd(long value, BCD_NUM far *bcd);
BCD_NUM far *ulong_to_bcd(unsigned long value, BCD_NUM far *bcd);

/*
**  Conversion routines from packed BCD to int/long
*/
long bcd_to_long(BCD_NUM far *bcd);
unsigned long bcd_to_ulong(BCD_NUM far *bcd);
int bcd_to_int(BCD_NUM far *bcd);
unsigned int bcd_to_uint(BCD_NUM far *bcd);

/*
**  Comparison routines for packed BCD numbers, see defines above for
**      valid values for <func>
*/
int  bcd_compare(BCD_NUM far *bcd1, int func, BCD_NUM far *bcd2);

/*
**  Math functions
*/
BCD_NUM far *bcd_sub(BCD_NUM far *bcd1, BCD_NUM far *bcd2, BCD_NUM far *result);
BCD_NUM far *bcd_add(BCD_NUM far *bcd1, BCD_NUM far *bcd2, BCD_NUM far *result);
BCD_NUM far *bcd_mul(BCD_NUM far *bcd1, BCD_NUM far *bcd2, BCD_NUM far *result);
BCD_NUM far *bcd_div(BCD_NUM far *bcd1, BCD_NUM far *bcd2, BCD_NUM far *result, BCD_NUM far *remain);

/*
**  Math functions, with respective decimal places
*/
BCD_NUM far *bcd_addd(BCD_NUM far *bcd1, int bcd1_dec, BCD_NUM far *bcd2, int bcd2_dec, BCD_NUM far *result, int res_dec);
BCD_NUM far *bcd_subd(BCD_NUM far *bcd1, int bcd1_dec, BCD_NUM far *bcd2, int bcd2_dec, BCD_NUM far *result, int res_dec);
BCD_NUM far *bcd_muld(BCD_NUM far *bcd1, int bcd1_dec, BCD_NUM far *bcd2, int bcd2_dec, BCD_NUM far *result, int res_dec);
BCD_NUM far *bcd_divd(BCD_NUM far *bcd1, int bcd1_dec, BCD_NUM far *bcd2, int bcd2_dec, BCD_NUM far *result, BCD_NUM far *remain, int res_dec);
BCD_NUM far *bcd_percent(BCD_NUM far *bcd1, int bcd1_dec, BCD_NUM far *bcd2, int bcd2_dec, BCD_NUM far *result, int res_dec);

/*
**  BCD Shift functions
*/
BCD_NUM far *bcd_shleft(BCD_NUM far *bcd1, int number, BCD_NUM far *result);
BCD_NUM far *bcd_shright(BCD_NUM far *bcd1, int number, BCD_NUM far *result);

#endif
