/******************************************************************************
*
*       Module: scrwin.h
*
*  Description: Header file for Windows system
*
*******************************************************************************/
#ifndef         TRUE
#define         TRUE    1
#define         FALSE   0
#endif
  
#if     !defined(__SCRWIN)
#   define	   __SCRWIN
  
#if	!defined(__COLORS)
#   include	   "conio.h"
#endif
  
/*  border types for make_window */
#define 	No_Border	0
#define 	Single_Border	1
#define 	Double_Border	2
  
/*  initialization codes defined */
#define 	UNINIT		0xFF
#define 	INITIALIZED	0x00
  
/*  macro for creating a color attribute  */
#define 	attr(fore,back)  ((((back) << 4) | (fore)))
#define 	background(A) ((A & 0xF0) >> 4)
#define 	foreground(A) (A & 0x0F)

extern char	scredit_colors[];
extern char	xlate_colors;	   /*  Should color translation take place? (default TRUE) */

/*
**	Displays an error message window on line 25, color is
**		RED on WHITE
*/
void error_window (char far *mesg);
  
/*
**  Window structure definition and function declarations
**	Returns NULL if memory could not be allocated to save the window
**	 area, otherwise returns a pointer back to win_buf.
*/
typedef struct {
    char    init;                   /* is this window initialized?          */
    char    row;                    /* upper left row corner                */
    char    col;                    /* upper left column corner             */
    char    num_rows;               /* number of rows                       */
    char    num_cols;               /* number of columns                    */
    char    txt_attr;               /* screen color background/foreground   */
    char    bdr_type;               /* border type                          */
    char    bdr_attr;               /* border attribute                     */
    char    title[80];              /* window title                         */
    char    fill_char;		    /* fill character for window background */
  
    int     win_number;             /* number of saved window               */
    char far  *save_window;         /* saved text, etc. behind window       */
    unsigned int old_curs_type;     /* last cursor type                     */
    char    col_lwr;
    char    row_lwr;
    char    old_winleft;            /* old window settings                  */
    char    old_wintop;
    char    old_winright;
    char    old_winbottom;
    char    old_x;                  /* old x setting                        */
    char    old_y;                  /* old y setting                        */
    char    old_attrib;
}  WINDO;
  
WINDO far *make_window (WINDO far *win_buf);
void remove_window (WINDO far *win_buf);
void move_window (WINDO far *win_buf, int direction);
  
/*
**  Barmenu structure definition and function declarations
**
**	Returns -1 if error creating the window, returns -2 if ESC was pressed
**	 to exit the bar menu, otherwise returns the index of the selection
**	 made (0 - x), corresponding to the selection pointed to in
**	 ** selections.
**
**	If hotactive is TRUE, then 'hot' letters are active, otherwise they
**	  are not.
*/
#define         POPBAR_LJ       0x0000  /* left justify the selections on the bar menu */
#define         POPBAR_CTR      0x0001  /* center the selections on the bar menu */
#define         POPBAR_RJ       0x0002  /* right justify the selections on the bar menu */
#define         POPBAR_PTUSD    0x0100  /* only paint the portion of the bar menu that will be used */
#define         POPBAR_SMSK     0x00FF  /* AND mask for centering info */

typedef struct {
    char    init;                   /* has this been initialized?           */
    char    attrib;                 /* attribute of bar                     */
    char    norm_attrib;            /* attribute of selections - normal     */
    char    hilit_attrib;           /* attribute of selections - hilited    */
    char    lnorm_attrib;           /* attribute of hot letter - normal     */
    char    lhilit_attrib;          /* attribute of hot letter - hilited    */
    int     hot_active;             /* TRUE if 'hot' letters are active, FALSE otherwise */
    int     passkey;                /* TRUE if non-window controls are to
                                              be passed back to caller, otherwise
                                              FALSE                               */
    char  far **selections;         /* pointer to selections                */
    int     center_selections;      /* see POPBAR_??? defines above         */
    char    fill_char;		    /* character to fill background with    */
    int     num_columns;	    /* number of columns for bar menu	    */
  
    char    hot_letters[20];        /* 'hot' letters for the menu           */
    char    hot_pos[20];            /* array position of 'hot' letters      */
    char    selection_start[20];    /* columns each selection starts in on bar */
    int     cur_select;             /* current selection on screen          */
    int     max_selections;         /* maximum number of selections         */
    WINDO   save_win;               /* saved window                         */
}  POPBAR;
  
int make_bar_menu (POPBAR far *bar_buf, int row);
void remove_bar_menu (POPBAR far *bar_buf);
void paint_bar_menu_select (POPBAR far *bar_buf, int prev_sel);

/*
**  Pulldown Menu structure and function declarations.
**	Returns -1 if error creating the window, returns -2 if ESC was pressed
**	 to exit the bar menu, -3 if row, column parm errors (row must be 2 or
**	 more, column 1 or more, row + num_rows < 25, col + num_cols < 80)
**	 otherwise returns the index of the selection made (0 - x),
**	 corresponding to the selection pointed to in ** selections.
**
**	If passkey is set to TRUE, the key pressed will be returned to the
**	 caller for processing.
**
**	If hotactive is TRUE, then 'hot' letters are active, otherwise they
**	  are not.
*/

/*  values for enumerate in make_pulldown_menu */
#define 	No_Enumerate	-1		/* do not number selections */
#define 	Enum_0_Relative 0		/* number selections, 0 relative */
#define 	Enum_1_Relative 1		/* number selections, 1 relative */
  
typedef struct {
    char    init;                   /* has this been initialized?           */
    char    row;                    /* upper left row corner                */
    char    col;                    /* upper left column corner             */
    char    attrib;                 /* attribute of bar                     */
    char    norm_attrib;            /* attribute of selections - normal     */
    char    hilit_attrib;           /* attribute of selections - hilited    */
    char    lnorm_attrib;           /* attribute of hot letter - normal     */
    char    lhilit_attrib;          /* attribute of hot letter - hilited    */
    char    bdr_type;               /* type of border                       */
    int     e_value;                /* value of variable enumerate          */
    int     passkey;                /* TRUE if non-window controls are to
                                              be passed back to caller, otherwise
                                              FALSE                               */
    int     hot_active;             /* TRUE if 'hot' letters are active, FALSE otherwise */
    char far *title;		    /* title for window 		    */
    char far **selections;	    /* pointer to selections		    */
    char    fill_char;		    /* character to fill background with    */
  
    char    hot_letters[20];        /* 'hot' letters for the menu           */
    char    hot_pos[20];            /* array position of 'hot' letters      */
    int     cur_select;             /* current selection on screen          */
    int     max_selections;         /* maximum number of selections         */
    WINDO   save_win;               /* saved window                         */
}  PULLDOWN;
int make_pulldown_menu (PULLDOWN far *pulldown);
void remove_pulldown_menu (PULLDOWN far *pulldown);


/*
**  Pulldown Menu Selection Window structure and function declarations.
**	Returns -1 if error creating the window, returns -2 if ESC was pressed
**	 to exit the bar menu, -3 if row, column parm errors (row must be 2 or
**	 more, column 1 or more, row + num_rows < 25, col + num_cols < 80)
**	 otherwise returns the index of the selection made (0 - x),
**	 corresponding to the selection pointed to in ** selections.
**
**	If passkey is set to TRUE, the key pressed will be returned to the
**	 caller for processing.
**
**	If hotactive is TRUE, then 'hot' letters are active, otherwise they
**	  are not.
*/
typedef struct {
    char    init;                   /* has this been initialized?           */
    char    row, col;		    /* upper left row/column corner	    */
    char    numrows, numcols;	    /* number of rows, columns		    */
    char    attrib;                 /* attribute of bar                     */
    char    bdr_type;               /* border type                          */
    char    bdr_attr;               /* border attribute                     */
    char    norm_attrib;            /* attribute of selections - normal     */
    char    hilit_attrib;           /* attribute of selections - hilited    */
    int     passkey;                /* TRUE if non-window controls are to
                                              be passed back to caller, otherwise
                                              FALSE                               */
    char far *title;		    /* title for window 		    */
    char far **selections;	    /* pointer to selections		    */
    char    fill_char;		    /* character to fill background with    */
  
    int     cur_select;             /* current selection on screen          */
    int     max_selections;         /* maximum number of selections         */
    WINDO   save_win;               /* saved window                         */
}  PULLSEL;

int make_pullsel_menu (PULLSEL far *pullsel);
void remove_pullsel_menu (PULLSEL far *pullsel);
  
#endif	    /* !defined(__SCRWIN) */
  
/*  end of file  */
