%{
/**
 * scpp - selective C preprocessor
 *  Lexical scanner
 *
 * Copyright (c) 1985 by
 * Tektronix, Incorporated Beaverton, Oregon 97077
 * All rights reserved.
 *
 * Permission is hereby granted for personal, non-commercial
 * reproduction and use of this program, provided that this
 * notice and all copyright notices are included in any copy.
 */

#include <stdio.h>

#undef input
#undef unput
#define input() (*nxtin == ATTN ? nxtc() : *nxtin++)
#define unput(c) unc(c)

#include "scpp.h"
#include "ytab.h"

int lasttok = NL;  /* used to detect ^# when lex can't    */
#define yield(t) lasttok = t; questr(yytext, yyleng); return(t)

/*
 * All input to higher levels of scpp is provided exclusively by this
 *  lexical analyzer, xxlex().
 * This routine is called xxlex() rather than yylex() because the "#if"
 *  expression parser uses a slightly different lexical analyzer (which
 *  calls xxlex()).
 */

%}
%%

"<"     {yield(LT);}
"<="    {yield(LE);}
">"     {yield(GT);}
">="    {yield(GE);}
","     {yield(CM);}
"/"     {yield(DIV);}
"%"     {yield(MOD);}
"+"     {yield(PLUS);}
"-"     {yield(MINUS);}
"<<"    {yield(LS);}
">>"    {yield(RS);}
"*"     {yield(MUL);}
"=="    {yield(EQ);}
"!="    {yield(NE);}
"&"     {yield(AND);}
"|"     {yield(OR);}
"^"     {yield(ER);}
"&&"    {yield(ANDAND);}
"||"    {yield(OROR);}
"?"     {yield(QUEST);}
":"     {yield(COLON);}
"!"     {yield(NOT);}
"~"     {yield(COMPL);}
"("     {yield(LP);}
")"     {yield(RP);}
","     {yield(CM);}
[ \t]+   {yield(WHITE);  /* whitespace */}
\\\n    {/* escaped newline */
                if (curfile->af_raw) {
                        curfile->af_line++;
                }
                yield(QNL);
        }
\n      {/* unescaped newline */
                if (curfile->af_raw) {
                        curfile->af_line++;
                }
                yield(NL);
        }
0x[0-9a-fA-F]+[Ll]?     {yield(INT); /* hex constant */}
[0-9]+[Ll]?             {yield(INT); /* decimal or octal constant */}
[0-9]+[Ee]([+-][0-9])?[0-9]*            |
\.[0-9]+([Ee]([+-][0-9])?[0-9]*)?       |
[0-9]+\.[0-9]*([Ee]([+-][0-9])?[0-9]*)? {yield(FLOAT); /* floating constant */}
[a-zA-Z_][a-zA-Z0-9_]*  {yield(IDENT); /* identifier */}
\'      {yield(QUOTE);}
\"      {yield(DQUOTE);}
\\      {yield(BACKS);}
"/*"    {yield(OPENC); /* start (open) comment */}
"*/"    {yield(CLOSEC);/* finish (close) comment */}
#       {/*
          * a control line if preceeded immediately by a newline,
          *  even if that newline was the result of macro interpretation.
          */
                if (lasttok == NL) {
                        yield(POUNDLINE);
                }
                yield(OTHER);
        }
.       {yield(OTHER);}

%%
