/*******************************************************************************
*   SCL1KEYS.H - Keyboard SCAN/ASCII code constants, SCL1 library version 2.1  *
*                                                                              *
*          Copyright (C) 1990 by Jos Rodrguez Alvira & Jos R. Lebrn        *
*******************************************************************************/

#define ESC      0x011b
#define ENTER    0x1c0d
#define SPACE    0x3920
#define INS      0x5200
#define DEL      0x5300
#define BACK     0x0E08
#define TAB      0x0F09
#define SHIFTTAB 0x0f00

#define F1  0x3b00
#define F2  0x3c00
#define F3  0x3d00
#define F4  0x3e00
#define F5  0x3f00
#define F6  0x4000
#define F7  0x4100
#define F8  0x4200
#define F9  0x4300
#define F10 0x4400

#define ALTF1  0x6800
#define ALTF2  0x6900
#define ALTF3  0x6A00
#define ALTF4  0x6B00
#define ALTF5  0x6C00
#define ALTF6  0x6D00
#define ALTF7  0x6E00
#define ALTF8  0x6F00
#define ALTF9  0x7000
#define ALTF10 0x7100

#define CTRLF1  0x5E00
#define CTRLF2  0x5F00
#define CTRLF3  0x6000
#define CTRLF4  0x6100
#define CTRLF5  0x6200
#define CTRLF6  0x6300
#define CTRLF7  0x6400
#define CTRLF8  0x6500
#define CTRLF9  0x6600
#define CTRLF10 0x6700

#define SHIFTF1  0x5400
#define SHIFTF2  0x5500
#define SHIFTF3  0x5600
#define SHIFTF4  0x5700
#define SHIFTF5  0x5800
#define SHIFTF6  0x5900
#define SHIFTF7  0x5A00
#define SHIFTF8  0x5B00
#define SHIFTF9  0x5C00
#define SHIFTF10 0x5D00

#define UP        0x4800
#define DOWN      0x5000
#define RIGHT     0x4d00
#define LEFT      0x4b00
#define HOME      0x4700
#define END       0x4F00
#define PgUp      0x4900
#define PgDn      0x5100
#define CTRLRIGHT 0x7400
#define CTRLLEFT  0x7300
#define CTRLHOME  0x7700
#define CTRLEND   0x7500
#define CTRLPgUp  0x8400
#define CTRLPgDn  0x7600

#define ALTA  0x1e00
#define ALTB  0x3000
#define ALTC  0x2e00
#define ALTD  0x2000
#define ALTE  0x1200
#define ALTF  0x2100
#define ALTG  0x2200
#define ALTH  0x2300
#define ALTI  0x1700
#define ALTJ  0x2400
#define ALTK  0x2500
#define ALTL  0x2600
#define ALTM  0x3200
#define ALTN  0x3100
#define ALTO  0x1800
#define ALTP  0x1900
#define ALTQ  0x1000
#define ALTR  0x1300
#define ALTS  0x1f00
#define ALTT  0x1400
#define ALTU  0x1600
#define ALTV  0x2f00
#define ALTW  0x1100
#define ALTX  0x2d00
#define ALTY  0x1500
#define ALTZ  0x2c00

#define CTRLA  0x1e01
#define CTRLB  0x3002
#define CTRLC  0x2e03
#define CTRLD  0x2004
#define CTRLE  0x1205
#define CTRLF  0x2106
#define CTRLG  0x2207
#define CTRLH  0x2308
#define CTRLI  0x1709
#define CTRLJ  0x240a
#define CTRLK  0x250b
#define CTRLL  0x260c
#define CTRLM  0x320d
#define CTRLN  0x310e
#define CTRLO  0x180f
#define CTRLP  0x1910
#define CTRLQ  0x1011
#define CTRLR  0x1312
#define CTRLS  0x1f13
#define CTRLT  0x1414
#define CTRLU  0x1615
#define CTRLV  0x2f16
#define CTRLW  0x1117
#define CTRLX  0x2d18
#define CTRLY  0x1519
#define CTRLZ  0x2c1a

/* Enhanced keyboard keys */

#define ENH_ENTER     0xe00d
#define ENH_DEL       0x53e0
#define ENH_INS       0x52e0
#define ENH_END       0x4fe0
#define ENH_PgDn      0x51e0
#define ENH_PgUp      0x49e0
#define ENH_LEFT      0x4be0
#define ENH_DOWN      0x50e0
#define ENH_RIGHT     0x4de0
#define ENH_UP        0x48e0
#define ENH_HOME      0x47e0
#define F11           0x8500
#define F12           0x8600
#define SHIFTF11      0x8700
#define SHIFTF12      0x8800
#define CTRLF11       0x8900
#define CTRLF12       0x8a00
#define ALTF11        0x8b00
#define ALTF12        0x8c00
#define ENH_CTRLRIGHT 0x74e0
#define ENH_CTRLLEFT  0x73e0
#define ENH_CTRLENTER 0xe00a
#define ENH_CTRLPgUp  0x84e0
#define ENH_CTRLPgDn  0x76e0
#define ENH_CTRLEND   0x75e0
#define ENH_CTRLHOME  0x77e0


/* KeyStatus */

#define RSHIFT          1
#define LSHIFT          2
#define CTRL            4
#define ALT             8
#define SCROLL         16
#define NUML           32
#define CAPSL          64
#define INSERT        128
#define LEFT_CTRL     256
#define LEFT_ALT      512
#define RIGHT_CTRL   1024
#define RIGHT_ALT    2048
#define SCROLL_DOWN  4096
#define NUML_DOWN    8192
#define CAPSL_DOWN  16384
#define SYSREQ      32768
