/* sctest.c */

/* A simple test program for linear scaling algorithms. */

#include "stdio.h"
#include "stdlib.h"
#include "basics.h"
#include "scale.h"

#define PRECISION 14

void main (void);

void main ()
{
   #define BUF_LEN   128

   char     szBuf[BUF_LEN + 1];
   double   dDataMin;
   double   dDataMax;
   int      nIntervals;
   double   dNiceNum;
   double   dLoMult;
   double   dHiMult;

   fprintf (stderr, "\nType Q to quit\n\n");

   while (TRUE)
   {
      fprintf (stderr, "data minimum:  ");
      fgets (szBuf, BUF_LEN + 1, stdin);
      if (*szBuf == 'q' || *szBuf == 'Q')
      {
         break;
      }
      dDataMin = atof (szBuf);

      fprintf (stderr, "data maximum:  ");
      fgets (szBuf, BUF_LEN + 1, stdin);
      if (*szBuf == 'q' || *szBuf == 'Q')
      {
         break;
      }
      dDataMax = atof (szBuf);

      fprintf (stderr, "# intervals:   ");
      fgets (szBuf, BUF_LEN + 1, stdin);
      if (*szBuf == 'q' || *szBuf == 'Q')
      {
         break;
      }
      nIntervals = atoi (szBuf);

      printf ("\n");
      printf ("(%.*g to %.*g) in %d\n",
            PRECISION, dDataMin, PRECISION, dDataMax, nIntervals);

      if (dDataMin < dDataMax)
      {
         if (nIntervals >= 2)
         {
            scDixonKronmal (dDataMin, dDataMax, nIntervals,
                  &dNiceNum, &dLoMult, &dHiMult);
            printf ("  Dixon-Kronmal - label (%.*g to %.*g) using %d intervals\n",
                  PRECISION, dLoMult * dNiceNum,
                  PRECISION, dHiMult * dNiceNum,
                  (int) (dHiMult - dLoMult));
            printf ("                    interval size %.*g\n",
                  PRECISION, dNiceNum);

            scLewart (dDataMin, dDataMax, nIntervals,
                  &dNiceNum, &dLoMult, &dHiMult);
            printf ("  Lewart        - label (%.*g to %.*g) using %d intervals\n",
                  PRECISION, dLoMult * dNiceNum,
                  PRECISION, dHiMult * dNiceNum,
                  (int) (dHiMult - dLoMult));
            printf ("                    interval size %.*g\n",
                  PRECISION, dNiceNum);

            scMaxInterval (dDataMin, dDataMax, nIntervals,
                  &dNiceNum, &dLoMult, &dHiMult);
            printf ("  Max Intervals - label (%.*g to %.*g) using %d intervals\n",
                  PRECISION, dLoMult * dNiceNum,
                  PRECISION, dHiMult * dNiceNum,
                  (int) (dHiMult - dLoMult));
            printf ("                    interval size %.*g\n",
                  PRECISION, dNiceNum);
         }
         else
         {
            printf ("  Dixon-Kronmal - must specify at least 2 intervals\n");
            printf ("  Lewart        - must specify at least 2 intervals\n");
            printf ("  Max Intervals - must specify at least 2 intervals\n");
         }

         if (nIntervals >= 5)
         {
            scInternal (dDataMin, dDataMax, nIntervals,
                  &dNiceNum, &dLoMult, &dHiMult);
            printf ("  Internal      - label (%.*g to %.*g) using %d intervals\n",
                  PRECISION, dLoMult * dNiceNum,
                  PRECISION, dHiMult * dNiceNum,
                  (int) (dHiMult - dLoMult));
            printf ("                    interval size %.*g\n",
                  PRECISION, dNiceNum);
         }
         else
         {
            printf ("  Internal      - must specify at least 5 intervals\n");
         }
      }
      else
      {
         printf ("   data minimum must be less than data maximum\n");
      }

      printf ("\n");
   }
}

/* end of file */
