//   ͻ
//                                                                       
//    module:      getobdsk.c                                            
//    abstract:    This module shows how to make 3.x system calls using  
//                 the F2 Shell Interface.  Obviously, it requires the   
//                 NetWare Shell.                                        
//                                                                       
//    environment: NetWare 3.x v3.11                                     
//                 Borland C 3.0                                         
//                                                                       
//     This software is provided as is and carries no warranty           
//     whatsoever.  Novell disclaims and excludes any and all implied    
//     warranties of merchantability, title and fitness for a particular 
//     purpose.  Novell does not warrant that the software will satisfy  
//     your requirements or that the software is without defect or error 
//     or that operation of the software will be uninterrupted.  You are 
//     using the software at your risk.  The software is not a product   
//     of Novell, Inc. or any of subsidiaries.                           
//   ͼ
//
//                         ****** N O T I C E ******
//    
//     This software is considered pre-release and may be used at your own
//     risk and has been provided due to the many requests of our cust-
//     omers. 
//

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <dos.h>

#include "nwsys.h"

//
//  First of all, we define the request and reply structures which are
//  needed for the GetBinderyObjectID API call.  These structures
//  are layed out according to the System Call documentation.
//

struct  {
    WORD    sflen;          // length of the structure 
    BYTE    sfcode;         // the subfunction code
    WORD    otype;          // object type (hi-lo)
    BYTE    onlen;          // length of name (below)
    BYTE    oname[48];      // name 
}GETOBJRequest;

struct  {
    LONG    oid;            // the object ID returned (hi-lo)
    WORD    otype;          // the object type returned (hi-lo)
    BYTE    oname[48];      // the object name returned (ASCIIZ)
}GETOBJReply;

//  First of all, we define the request and reply structures which are
//  needed for the GetObjectDiskUsageAndRestriction API call.  These
//  structures are layed out according to the System Call documentation.
//

struct  {
    WORD    sflen;          // length of the structure
    BYTE    sfcode;         // the subfunction code
    BYTE    volumeNumber;   // volume number
    LONG    oid;            // object for which information is to be returned
}GETOBDSKRequest;

struct  {
    LONG    restriction;    //  Restriction on object for specified volume
    LONG    inUse;          //  Actual space in use by object
}GETOBDSKReply;

//
//  This is the main program.  The purpose is to make the GetObjectDisk
//  Restriction API call to illustrate making system calls using the
//  F2 interface.
//

void main(int argc, char *argv[])
{
	int     cc;
	int     length;

	if(argc!=4){printf("usage: GETOBDSK objectName ObjectType VolumeNumber\n");exit(1);}
//
//  Build the request buffer
//
   GETOBJRequest.sfcode = 53;                        // subfunction code
   GETOBJRequest.otype  = WordSwap(atoi(argv[2]));   // object type
   GETOBJRequest.onlen  = strlen(argv[1]);           // object name length
   GETOBJRequest.sflen  = WordSwap(6+GETOBJRequest.onlen);
                                                     // length of this request
   strcpy(GETOBJRequest.oname,argv[1]);              // object name

   cc = NWSystemCall(23,&GETOBJRequest,sizeof GETOBJRequest,&GETOBJReply,sizeof GETOBJReply);

   printf("Function returned:    %03d--%#02x\n",cc,cc);
   if( cc == 0 ){
       printf("Object id returned:   %#010lx\n",DWordSwap(GETOBJReply.oid));
       printf("Object type returned: %#06x\n",WordSwap(GETOBJReply.otype));
       printf("Object name returned: %s\n",GETOBJReply.oname);
   }
//
//  Build the request buffer for the restriction call
//
   GETOBDSKRequest.sflen = sizeof GETOBDSKRequest;
   GETOBDSKRequest.sfcode = 41;                       // subfunction code
   GETOBDSKRequest.volumeNumber=atoi(argv[3]);
   GETOBDSKRequest.oid=GETOBJReply.oid;
   cc = NWSystemCall(22,&GETOBDSKRequest,sizeof GETOBDSKRequest,&GETOBDSKReply,sizeof GETOBDSKReply);
   printf("Function returned:    %03d--%#02x\n",cc,cc);
   if( cc == 0 ) {
       printf("Restriction:          %8ld\n",GETOBDSKReply.restriction);
       printf("In Use:                 %8ld\n",GETOBDSKReply.inUse);
   }
}
