//   ͻ
//                                                                       
//    module:      3xsc.c                                                
//    abstract:    This module shows how to make 3.x system calls using  
//                 the F2 Shell Interface.  Obviously, it requires the   
//                 NetWare Shell.                                        
//                                                                       
//    environment: NetWare 3.x v3.11                                     
//                 Borland C 3.0                                         
//                                                                       
//     This software is provided as is and carries no warranty           
//     whatsoever.  Novell disclaims and excludes any and all implied    
//     warranties of merchantability, title and fitness for a particular 
//     purpose.  Novell does not warrant that the software will satisfy  
//     your requirements or that the software is without defect or error 
//     or that operation of the software will be uninterrupted.  You are 
//     using the software at your risk.  The software is not a product   
//     of Novell, Inc. or any of subsidiaries.                           
//                                                                       
//         ****    NOTICE    ****    NOTICE   ****   NOTICE   ****       
//                                                                       
//     This example code has not been extensively tested and therefore   
//     should be run on a test server before used in a production en-    
//     vironment.  Also, a backup is recommended before the installation 
//     of any untested component.                                        
//   Ķ
//    maintenance history:                                               
//    level    date      pi   description                                
//   Ķ
//     001   10/01/92    cm   Intial release.                            
//     002   04/23/93    mp   Added missing prototypes, fixed sopen call 
//   ͼ

#include <conio.h>
#include <io.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <dos.h>
#include "nwsys.h"
#include <share.h>
#include <fcntl.h>
#include <sys/stat.h>

//
//  First of all, we define the request and reply structures which are
//  needed for the ScanConnectionsUsingFile API call.  These structures are
//  layed out according to the System Call documentation.
//

struct  {
	 WORD    sflen;          // length of the structure
	 BYTE    sfcode;         // the subfunction code
	 BYTE    forkType;       // type of file
	 BYTE    volumeNumber;   // volume number
	 LONG    sequenceNumber; // dirEntry sequence number
	 WORD    lastRecordSeen; // last record
} Request;

typedef struct {
	WORD	connectionNumber;  // connection number holding file open
	WORD	taskNumber;        // task holding file open
	BYTE	lockType;          // lock type
	BYTE	accessFlag;        // access
	BYTE	lockFlag;          // lock flag
} CONN_INFO;

struct {
	WORD 	nextRequest;       // next record
	WORD  useCount;          // use count
	WORD  openCount;         // total times file is open
	WORD	openForReadCount;  // total open for read
	WORD	openForWriteCount; // total open for write
	WORD  denyReadCount;     // deny read flag/total
	WORD  denyWriteCount;    // deny write flag/total
	BYTE	locked;            // lock status
	BYTE 	fork;              // file type
	WORD	connCount;         // number of connection entries
	CONN_INFO
			connInfo[70];      // individual connection info
} Reply;

//
//  This is the main program.  The purpose is to make the ScanConnections
//  UsingFiles API call to illustrate making system calls using the F2
//  interface.
//

int ConvertPathToDirEntry(char *path, BYTE *volume, LONG *dirEntry);

int main(int argc, char *argv[])
{
	int   cc;
	char	dirPath[255];
	BYTE	volumeNumber;
	LONG	sequenceNumber;
	int	fileHandle;

	if(argc!=2) {
        printf("usage: cusefile FullPath\n");
        exit(1);
    }
	strcpy(dirPath,argv[1]);
	fileHandle=sopen(dirPath, O_TEXT, SH_DENYNO);
	if(fileHandle == -1) {
		printf("\nUnable to open %s.",dirPath);
		exit(1);
	}
	//
	//  Build the request buffer
	//
	cc=ConvertPathToDirEntry(dirPath, &volumeNumber, &sequenceNumber);
	if( cc ) {
		printf("%s not Found.",dirPath);
		exit(1);
	}
	Request.sflen = (sizeof Request) ;
	Request.sfcode = 236;                       // subfunction code
	Request.forkType = 0;
	Request.volumeNumber = volumeNumber;
	Request.sequenceNumber = sequenceNumber;
	Request.lastRecordSeen = 0;
	cc = NWSystemCall(23,&Request,sizeof Request,&Reply,sizeof Reply);
	printf("Function returned:    %03d--%#02x\n",cc,cc);
	printf("\nPress any key to close file!");
	getch();
	close(fileHandle);
	return 0;
}

int ConvertPathToDirEntry(char *path, BYTE *volume, LONG *dirEntry)
{
	static struct {
		WORD  sflen;             // length of the structure
		BYTE  sfcode;            // the subfunction code
		BYTE  dirHandle;         // type of file
		BYTE  pathStringLength;  // length of path
		BYTE  pathString[255];   // path
	} dirEntryRequest;

   static struct {
		BYTE	volumeNumber;   // volume number
		LONG	dirEntry;       // directory entry sequence
	} dirEntryReply;
	int	cc;

	dirEntryRequest.sflen=sizeof(dirEntryRequest);
	dirEntryRequest.sfcode=0xF4;
	dirEntryRequest.dirHandle=0x00;
	dirEntryRequest.pathStringLength=strlen(path);
	memcpy(&dirEntryRequest.pathString,path,strlen(path));
	cc = NWSystemCall(23,&dirEntryRequest,sizeof dirEntryRequest,&dirEntryReply,sizeof dirEntryReply);
	if( !cc) {
		*volume=dirEntryReply.volumeNumber;
		*dirEntry=dirEntryReply.dirEntry;
	}
	return( cc );
}

