//   IMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM;
//   :                                                                    :
//   : module:      connopen.c                                            :
//   : abstract:    This module shows how to make 3.x system calls using  :
//   :              the F2 Shell Interface for the GetConnectionsOpen     :
//   :              Files API, obviously it requires the NetWare Shell.   :
//   :                                                                    :
//   :              This call may need to be made iteratively to return   :
//   :              all of the restriction information.  For simplicity,  :
//   :              this example only makes the call once.                :
//   :                                                                    :
//   : environment: NetWare 3.x v3.11                                     :
//   :              Borland C 3.0                                         :
//   :                                                                    :
//   :  This software is provided as is and carries no warranty           :
//   :  whatsoever.  Novell disclaims and excludes any and all implied    :
//   :  warranties of merchantability, title and fitness for a particular :
//   :  purpose.  Novell does not warrant that the software will satisfy  :
//   :  your requirements or that the software is without defect or error :
//   :  or that operation of the software will be uninterrupted.  You are :
//   :  using the software at your risk.  The software is not a product   :
//   :  of Novell, Inc. or any of subsidiaries.                           :
//   HMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM<
//
//                         ****** N O T I C E ******
//
//     This API call can cause a server abend if a connection number is
//     used that is greater than what the OS supports.
//
//     This software is considered pre-release and may be used at your own
//     risk and has been provided due to the many requests of our cust-
//     omers.  Support for this module will be provided at the sole
//     discretion of Novell, Inc.
//

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>

#include "nwsys.h"

//
//  Since the file names are returned length preceded, the file name is
//  not a constant 12 or 13 bytes.  The maximum names that can be returned
//  is based upon a maximum reply buffer length of 512 bytes.
//

#define MAX_RETURNED 27

//
//  First of all, we define the request and reply structures which are
//  needed for the GetConnectionsOpenFiles API call.  These structures are
//  layed out according to the System Call documentation.
//

struct  REQUEST {
	 WORD    sflen;                 // length of the structure
	 BYTE    sfcode;                // the subfunction code
	 WORD    connNumber;            // target connection number
	 WORD    lastRecordSeen;        // last record returned, i.e. sequence
}Request;

struct fileStruct{
	 WORD    taskNumber;            // task number within ws holding file open
	 BYTE    lockType;              // lock type, ie sharable, logged, locked, TTS
	 BYTE    accessControl;         // access rights to file
	 BYTE    lockFlag;              // lock flag
	 BYTE    volumeNumber;          // volume number file resides upon
	 LONG    parentDirEntryNumber;  // parent directory entry seq number
	 LONG    dirEntryNumber;        // directory entry seq number
	 BYTE    reserved[1];           // reserved for future use
	 BYTE    nameSpace;             // name space identifier
	 BYTE    fileName[13];          // name of file (null terminated)
};

struct   fileStruct *fs[MAX_RETURNED];
											  // array of pointers to file info
int   numOpenFiles;                // number of open files
WORD  connectionNumber;            // connection number to query

struct  {
	 WORD    nextRequestRec; // next record to be requested.
	 WORD    numberReturned; // number of records returned
	 BYTE    buffer[508];    // raw reply data
}Reply;

void ProcessEntries(void);
void FreeEntries(void);
void DisplayData(void);
int GetPath(int, BYTE *);
int GetVolumeName(BYTE *, BYTE *);
void NetWarePathToDOSPath(BYTE *);
//
//  This routine allocates memory for the data returned for each file.
//  It also makes the GetConnectionOpenFiles call and parses the reply
//  buffer.
//
void ProcessEntries(void)
{
	char *lookup;						  // pointer for the reply buffer
	int i,j;                        // iteration counters

	lookup=(char *)&Reply.buffer;
	numOpenFiles=Reply.numberReturned;
	if(numOpenFiles > MAX_RETURNED) {
		printf("\nToo many files returned!  Must ABORT");
		return;
	}
	for(i=0;i < numOpenFiles; i++) {
		fs[i]=malloc(sizeof (struct fileStruct));
		memmove((char *)&fs[i]->taskNumber,(lookup),2);
		fs[i]->lockType=*(lookup+2);
		fs[i]->accessControl=*(lookup+3);
		fs[i]->lockFlag=*(lookup+4);
		fs[i]->volumeNumber=*(lookup+5);
		memmove((char *)&fs[i]->parentDirEntryNumber,(lookup+6),4);
		memmove((char *)&fs[i]->dirEntryNumber,(lookup+10),4);
		memmove(fs[i]->reserved,(lookup+14),1);
		fs[i]->nameSpace=*(lookup+15);
		for(j=0;j<*(lookup+16);j++)
			fs[i]->fileName[j]=*(lookup+17+j);
		fs[i]->fileName[j]='\0';
		lookup=(lookup+17+j);
	}
}

//
//  This routine frees memory allocated by ProcessEntries.
//
void FreeEntries( void )
{
	int i;                          // iteration counter

	for(i=0;i<numOpenFiles;i++)
		free(fs[i]);
}

//
//  Display the list of open files for the connection.
//
void DisplayData( void )
{
	int i;                          // iteration counter
	int cc;                         // completion code
	char path[255];                 // returned path

	printf("\n\nList Of %d Open Files For Connection %d\n\n",
		numOpenFiles,
		connectionNumber);
	for(i=0;i<numOpenFiles;i++) {
		cc=GetPath(i,path);
		if( !cc ) printf("%s/%s\n",path,&fs[i]->fileName);
	}
}

//
//  This function will obtain the full volume NetWare path of a specified
//  volume number, directory entry number and name space set.  This function
//  calls the MapDirectoryNumberToPath and GetVolumeName NetWare APIs.
//
int GetPath(int offset, BYTE *directoryPath)
{
	static struct {
		WORD    sflen;               // length of the structure
		BYTE    sfcode;              // the subfunction code
		BYTE    volumeNumber;        // volume number
		LONG    dirEntryNumber;      // directory entry sequence number
		BYTE    nameSpace;           // name space
	} GetPathRequest;               // MapDirectoryNumberToPath request
											  // structure
	static struct {
		BYTE    directoryPath[255];  // NetWarePath (not the same as DOS path)
	} GetPathReply;                 // MapDirectoryNumberToPath reply
											  // structure
	BYTE volumeName[16];            // volume name
	int cc;                         // completion code

	memset(&GetPathRequest,'\0',sizeof GetPathRequest);
	memset(&GetPathReply,'\0',sizeof GetPathReply);
	GetPathRequest.sflen = (sizeof GetPathRequest) ;
	GetPathRequest.sfcode = 243;                       // subfunction code
	GetPathRequest.volumeNumber=fs[offset]->volumeNumber;
	GetPathRequest.dirEntryNumber=fs[offset]->parentDirEntryNumber;
	GetPathRequest.nameSpace=fs[offset]->nameSpace;
	cc = NWSystemCall(23,&GetPathRequest,sizeof GetPathRequest,
			&GetPathReply,sizeof GetPathReply);
	if(cc) {
		printf("MapDirectoryNumberToPath returned:    %03d--%#02x\n",cc,cc);
		return(cc);
	}
	cc=GetVolumeName(&fs[offset]->volumeNumber,volumeName);
	if(cc) {
		printf("GetVolumeName returned:    %03d--%#02x\n",cc,cc);
		return(cc);
	}
	NetWarePathToDOSPath(GetPathReply.directoryPath);
	strcpy(directoryPath,volumeName);
	strcat(directoryPath,GetPathReply.directoryPath);
	return(0);
}

//
//  This function will return the name of the specified volume.
//

int 	GetVolumeName(BYTE *volumeNumber, BYTE *volumeName)
{
	struct {
		WORD    sflen;               // length of the structure
		BYTE    sfcode;              // the subfunction code
		BYTE    volumeNumber;        // number of volume
	} VolumeNameRequest;            // GetVolumeName request structure

	struct {
		BYTE    volumeNameLength;    // volume name length
		BYTE    volumeName[255];     // volume name (not terminated)
	} VolumeNameReply;              // GetVolumeName reply structure

	int     cc;                     // completion code
	int volumeNameLength;           // length of volume name

	memset(&VolumeNameRequest,'\0',sizeof VolumeNameRequest);
	memset(&VolumeNameReply,'\0',sizeof VolumeNameReply);
	VolumeNameRequest.sflen = (sizeof VolumeNameRequest) ;
	VolumeNameRequest.sfcode = 06;                       // subfunction code
	VolumeNameRequest.volumeNumber=*volumeNumber;
	cc=NWSystemCall(22,&VolumeNameRequest,sizeof VolumeNameRequest,
			&VolumeNameReply,sizeof VolumeNameReply);
	if(cc) return(cc);
	volumeNameLength=(int)VolumeNameReply.volumeNameLength;
	memmove(volumeName,VolumeNameReply.volumeName,volumeNameLength);
	volumeName[volumeNameLength]='\0';
	return(0);
}

//
//  Convert a NetWare-Style path to a DOS-Style path, in place
//

void    NetWarePathToDOSPath( BYTE *psp )
{
	LONG    componentLen;

	componentLen = *psp;            // remember the length
	*psp++ = ':';                   // put volume separator
	psp += componentLen;            // get to next component
	while( *psp != '\0' ){
		componentLen = *psp;         // remember length
		*psp = '/';                  // put directory separator
		psp += componentLen + 1;     // to next component
	}
	*psp = NULL;                    // put null terminator
}

//
//  This is the main program.  The purpose is to make the GetConnections
//  OpenFiles API call to illustrate making system calls using the F2
//  interface.
//

void main(int argc, char *argv[])
{
	int     cc;
	if(argc!=2){printf("usage: CONNOPEN connectionNumber\n");exit(1);}
	connectionNumber=atoi(argv[1]);
//
//  Build the request buffer
//
	Request.sflen = (sizeof Request) ;
	Request.sfcode = 235;                       // subfunction code
	Request.connNumber = connectionNumber;
	Request.lastRecordSeen = 0;
	cc = NWSystemCall(23,&Request,sizeof Request,&Reply,sizeof Reply);
	if( cc ) printf("GetConnectionsOpenFiles returned:    %03d--%#02x\n",cc,cc);
	else {
		ProcessEntries();
		DisplayData();
		FreeEntries();
	}
}
