//   ͻ
//                                                                       
//    module:      sctrust.c                                             
//    abstract:    This module shows how to make 3.x system calls using  
//                 the F2 Shell Interface for the ScanEntryForTrustees   
//                 API, obviously it requires the NetWare Shell.         
//                                                                       
//                 This call may need to be made iteratively to return   
//                 all of the trustee information.  For simplicity,      
//                 this example only makes the call once.                
//                                                                       
//                 Whatever pathname is entered must be for the          
//                 currently logged drive, as this is not checked.       
//                 Wildcard expressions are not supported.               
//                                                                       
//    environment: NetWare 3.x v3.11                                     
//                 Borland C++ 3.1                                       
//                                                                       
//     This software is provided as is and carries no warranty           
//     whatsoever.  Novell disclaims and excludes any and all implied    
//     warranties of merchantability, title and fitness for a particular 
//     purpose.  Novell does not warrant that the software will satisfy  
//     your requirements or that the software is without defect or error 
//     or that operation of the software will be uninterrupted.  You are 
//     using the software at your risk.  The software is not a product   
//     of Novell, Inc. or any of subsidiaries.                           
//                                                                       
//   ͼ
//   
//                         ****** N O T I C E ******
//
//     This software is considered pre-release and may be used at your own
//     risk and has been provided due to the many requests of our cust-
//     omers.  Support for this module will be provided at the sole
//     discretion of Novell, Inc.
//

#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <dir.h>

#include "nwsys.h"

struct REQUEST {
    WORD sfLen;        // length of the structure
    BYTE sfCode;       // subfunction code
    BYTE dirHandle;    // directory handle
    BYTE sequence;     // starting set number
    BYTE pathLength;   // directory path length
    BYTE path[255];    // directory path buffer
} request;

struct REPLY {
    BYTE numEntries;   // number of trustee sets returned
    LONG objectID[20]; // trustee object ID
    WORD rights[20];   // trustee rights
} reply;

BYTE GetDirectoryHandle(int diskNumber)
{
	union   REGS    regs;

    memset(&regs, 0, sizeof(regs));

    regs.h.ah = 0xe9;
    regs.h.al = 0x00;
    regs.x.dx = diskNumber;

	intdos(&regs,&regs);       // do the Int 21

	return(regs.h.al);         // return code is in AL
}

int main()
{
    int i, retCode, diskNumber;
    WORD serverConnectionID;
    BYTE dirHandle;
    char fileName[80];

    printf("Pathname and/or filename to scan: ");
    gets(fileName);

    diskNumber = getdisk();

    dirHandle = GetDirectoryHandle(diskNumber);

    request.sfLen = sizeof(request);
    request.sfCode = 0x26;
    request.dirHandle = dirHandle;
    request.sequence = 0;
    strcpy(request.path, fileName);
    request.pathLength = strlen(request.path);;
    retCode = NWSystemCall(0x16, &request, sizeof(request),
                                 &reply,   sizeof(reply));
    if (retCode == 0) {
        printf("%d trustee sets returned.\n", reply.numEntries);
        printf("Trustee ID   Rights\n");
        for (i = 0; i < reply.numEntries; i++)
            printf("%10lu   0x%x\n", reply.objectID[i], reply.rights[i]);
    }
    else if (retCode == 156) 
        printf("No trustees exist for this entry.\n");
    else {
        printf("ScanEntryForTrustees call failed.  Return code = %d.\n",
            retCode);
        return(1);
    }
    return(0);
}
