//   ͻ
//                                                                       
//    module:      getfsinf.c                                            
//    abstract:    This module shows how to make 3.x system calls using  
//                 the F2 Shell Interface for the Get File Server        
//                 Information API, obviously it requires the NetWare    
//                 Shell.                                                
//                                                                       
//    environment: NetWare 3.x v3.11                                     
//                 Borland C++ 3.1                                       
//                                                                       
//     This software is provided as is and carries no warranty           
//     whatsoever.  Novell disclaims and excludes any and all implied    
//     warranties of merchantability, title and fitness for a particular 
//     purpose.  Novell does not warrant that the software will satisfy  
//     your requirements or that the software is without defect or error 
//     or that operation of the software will be uninterrupted.  You are 
//     using the software at your risk.  The software is not a product   
//     of Novell, Inc. or any of subsidiaries.                           
//                                                                       
//   ͼ
//
//                         ****** N O T I C E ******
//
//     This software is considered pre-release and may be used at your own
//     risk and has been provided due to the many requests of our cust-
//     omers.  Support for this module will be provided at the sole
//     discretion of Novell, Inc.
//

#include <stdio.h>
#include <string.h>
#include <dos.h>

#include "nwsys.c"

struct REQ_BUFF {
    WORD reqLen;          // Request Packet Length
    BYTE subFunc;
} reqBuff;

struct REP_BUFF {
    BYTE serverName[48];
    BYTE fsVersion;       // File Server Version
    BYTE fsSubVersion;    // File Server Sub Version
    WORD maxServConn;     // Maximum Supported Connections
    WORD connInUse;       // Connections in Use
    WORD numMountedVols;  // Number of Mounted Volumes
    BYTE revision;        // File Server Revision
    BYTE sftLevel;
    BYTE ttsLevel;
    WORD maxConnUsed;     // Max Connections Ever Used
    BYTE accountVersion;  // Accounting Version Number
    BYTE vapVersion;
    BYTE queueVersion;    // QMS Version Number
    BYTE printVersion;    // Print Server Version Number
    BYTE vConsoleVersion; // Virtual Console Version
    BYTE restrictLevel;   // Restriction Level
    BYTE internetBridge;  // Internet Bridge Support Version Number
    BYTE reserved[60];    // Reserved For Future Use
} repBuff;

int main()
{
    int retCode;

    reqBuff.reqLen = 3;
    reqBuff.subFunc = 0x11;

    retCode = NWSystemCall(0x17, &reqBuff, sizeof(struct REQ_BUFF),
                                 &repBuff, sizeof(struct REP_BUFF));
    if (retCode != 0) {
        printf("Get File Server Information call failed.  Return code = %d.\n",
            retCode);
        return(1);
    }
    printf("Server %s, running NetWare version %d.%d (revision %d)\n",
        repBuff.serverName, repBuff.fsVersion, repBuff.fsSubVersion,
        repBuff.revision);
    printf("Max supported connections: %u, Connections in use: %u\n",
        repBuff.maxServConn, repBuff.connInUse);
    printf("Max mounted volumes: %u, SFT level: %d, TTS level: %d\n",
        repBuff.numMountedVols, repBuff.sftLevel, repBuff.ttsLevel);
    return(0);
}
