//   ͻ
//                                                                       
//    module:      sctrpath.c                                            
//    abstract:    This module shows how to make 3.x system calls using  
//                 the F2 Shell Interface for the Scan Bindery Object    
//                 Trustee Paths API, obviously it requires the NetWare  
//                 Shell.                                                
//                                                                       
//                 This call may need to be made iteratively to return   
//                 all of the trustee information.  For simplicity,      
//                 this example only makes the call once.  To return     
//                 other entries, the sequence number returned by the    
//                 previous call must be passed into the next call.      
//                                                                       
//                 Whatever volume name is entered must be for the       
//                 default server.                                       
//                                                                       
//    environment: NetWare 3.x v3.11                                     
//                 Borland C++ 3.1                                       
//                                                                       
//     This software is provided as is and carries no warranty           
//     whatsoever.  Novell disclaims and excludes any and all implied    
//     warranties of merchantability, title and fitness for a particular 
//     purpose.  Novell does not warrant that the software will satisfy  
//     your requirements or that the software is without defect or error 
//     or that operation of the software will be uninterrupted.  You are 
//     using the software at your risk.  The software is not a product   
//     of Novell, Inc. or any of subsidiaries.                           
//                                                                       
//   ͼ
//
//                         ****** N O T I C E ******
//
//     This software is considered pre-release and may be used at your own
//     risk and has been provided due to the many requests of our cust-
//     omers.  Support for this module will be provided at the sole
//     discretion of Novell, Inc.
//

#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <dir.h>

#include "nwsys.c"

struct REQUEST {
    WORD sfLen;        // length of the structure
    BYTE sfCode;       // subfunction code
    BYTE volNumber;    // volume number
    WORD sequence;     // last sequence number
    LONG objectID;     // bindery object ID
} request;

struct REPLY {
    WORD sequence;     // next sequence number
    LONG objectID;     // bindery object ID
    BYTE accessMask;   // trustee access mask
    BYTE pathLength;   // length of directory path
    BYTE path[255];    // directory path
} reply;

struct VOL_REQ {
    WORD sfLen;
    BYTE sfCode;
    BYTE nameLen;
    BYTE name[16];
} volNumReq;

struct VOL_REP {
    WORD repLength;
    BYTE volNumber;
} volNumRep;

struct BIND_REQUEST {
    WORD  sfLen;            // length of the structure
    BYTE  sfCode;           // subfunction code
    WORD  objectType;       // bindery object type
    BYTE  objectNameLength; // name length: 1 to 47
    BYTE  objectName[48];   // bindery object name
} binderyRequest;

struct BIND_REPLY {
    WORD  replyLen;         // length of reply buffer
    DWORD objectID;         // bindery object ID
    WORD  objectType;       // bindery object type
    BYTE  objectName[48];   // bindery object name
} binderyReply;

WORD NWSystemCall2(BYTE func,             // function code
      		       void far *req,         // request buffer
		           void far *rep)         // reply buffer
{
	union   REGS    regs;
	struct  SREGS   sregs;

	segread(&sregs);

    memset(&regs, 0, sizeof(regs));

	regs.h.ah = func;               // AH = function code
	regs.x.si = FP_OFF(req);        // SI = request buffer offset
	regs.x.di = FP_OFF(rep);        // DI = reply buffer offset

	sregs.ds = FP_SEG(req);         // DS = request buffer segment
	sregs.es = FP_SEG(rep);         // ES = reply buffer segment

	intdosx(&regs,&regs,&sregs);    // do the Int 21

	return (WORD)regs.h.al;         // return code is in AL
}

BYTE GetVolumeNumber(char *volName)
{
    int retCode;

    volNumReq.sfCode = 0x05;
    volNumReq.nameLen = (BYTE) strlen(volName);
    memmove((char *) &(volNumReq.name), volName, volNumReq.nameLen);
    volNumReq.sfLen = volNumReq.nameLen + 2;

    retCode = NWSystemCall2(0xe2, &volNumReq, &volNumRep);
    if (retCode) {
        printf("Get Volume Number failed.  Return code = %d.\n", retCode);
        return(255);
    }
    else
        return(volNumRep.volNumber);
}

WORD GetBinderyObjectID(char *userName, WORD objectType, DWORD *objectID)
{
    int retCode;

    binderyRequest.sfLen = sizeof(binderyRequest);
    binderyRequest.sfCode = 0x35;
    binderyRequest.objectType = WordSwap(objectType);
    binderyRequest.objectNameLength = strlen(userName);
    strcpy((char *) &(binderyRequest.objectName), userName);
    binderyReply.replyLen = sizeof(binderyReply);

    retCode = NWSystemCall2(0xe3, &binderyRequest, &binderyReply);
    *objectID = binderyReply.objectID;
    return(retCode);
}

int main()
{
    int i, retCode, diskNumber;
    WORD serverConnectionID, objectType;
    DWORD objectID;
    BYTE volNumber;
    char name[80];

    printf("Volume name: ");
    gets(name);

    volNumber = GetVolumeNumber(name);

    if (volNumber == 255)
        return(1);

    printf("User name: ");
    gets(name);
    objectType = 1; /* OT_USER */

    retCode = GetBinderyObjectID(name, objectType, &objectID);
    if (retCode != 0) {
        printf("Get Bindery Object ID failed.  Return code = %d.\n", retCode);
        return(1);
    }

    request.sfLen = sizeof(request);
    request.sfCode = 0x47;
    request.volNumber = volNumber;
    request.sequence = -1L;
    request.objectID = objectID;
    retCode = NWSystemCall(0x17, &request, sizeof(request),
                                 &reply,   sizeof(reply));
    if (retCode == 0) 
        printf("%s    Access Mask:\n", reply.path, reply.accessMask);
    else {
        printf("Scan Bindery Object Trustee Paths failed.  Return code = %d.\n",
            retCode);
        return(1);
    }
    return(0);
}
