//   ͻ
//                                                                       
//    module:      OBFSDINF.C                                            
//    abstract:    This module shows how to make 3.x system calls using  
//                 the F2 Shell Interface for the Obtain File or         
//                 Subdirectory Information API, obviously it requires   
//                 the NetWare Shell.                                    
//                                                                       
//    environment: NetWare 3.x v3.11                                     
//                 Borland C++ 3.1                                       
//                                                                       
//     This software is provided as is and carries no warranty           
//     whatsoever.  Novell disclaims and excludes any and all implied    
//     warranties of merchantability, title and fitness for a particular 
//     purpose.  Novell does not warrant that the software will satisfy  
//     your requirements or that the software is without defect or error 
//     or that operation of the software will be uninterrupted.  You are 
//     using the software at your risk.  The software is not a product   
//     of Novell, Inc. or any of subsidiaries.                           
//                                                                       
//   ͼ
//
//                         ****** N O T I C E ******
//
//     This software is considered pre-release and may be used at your own
//     risk and has been provided due to the many requests of our cust-
//     omers.  Support for this module will be provided at the sole
//     discretion of Novell, Inc.
//

#include <stdio.h>
#include <string.h>

#include "nwsys.h"

struct OB_REQUEST {
    BYTE  sfCode;           // subfunction code
    BYTE  nameSpace;
    BYTE  destNameSpace;    // destination name space
    WORD  searchAttributes;
    DWORD returnInfoMask;   // return information mask
    BYTE  volumeNumber;
    DWORD dirHandle;        // directory base or short directory handle
    BYTE  handleFlag;
    BYTE  pathCompCount;    // path component count
    BYTE  buffer[512];
} obtainRequest;

struct OB_REPLY {
    BYTE  reserved1[4];
    BYTE  reserved2[6];
    BYTE  reserved3[4];
    BYTE  reserved4[6];
    BYTE  reserved5[8];
    BYTE  reserved6[10];
    BYTE  reserved7[8];
    BYTE  reserved8[2];
    BYTE  reserved9[12];
    BYTE  reserved10[12];
    DWORD creatorNameSpaceNumber;
    BYTE  reserved[257];
} obtainReply;

int main()
{
    int i, retCode;
    char volName[80], dirName[80], subDirName[80], fileName[80];
    BYTE *bufptr;

    obtainRequest.sfCode = 0x06;
    obtainRequest.nameSpace = 0;
    obtainRequest.destNameSpace = 0;
    obtainRequest.searchAttributes = 0xff;
    obtainRequest.returnInfoMask = 0x0200;
    obtainRequest.volumeNumber = 0;
    obtainRequest.dirHandle = 0xff;
    obtainRequest.handleFlag = 0xff;

    /* A qualified NetWare path must be passed to the function.  Every
       element of the path is included separately in the buffer,
       length-preceded.  This example uses SYS:MPINSONN\TEST\CONFIG.SYS.
       The pathCompCount parameter must equal the number of path
       components, in this case 4. */

    strcpy(volName,    "SYS");
    strcpy(dirName,    "MPINSONN");
    strcpy(subDirName, "TEST");
    strcpy(fileName,   "CONFIG.SYS");

    obtainRequest.pathCompCount = 4;
    bufptr = obtainRequest.buffer;

    *bufptr = strlen(volName);
    strcpy(++bufptr, volName);
    bufptr += strlen(volName);

    *bufptr = strlen(dirName);
    strcpy(++bufptr, dirName);
    bufptr += strlen(dirName);

    *bufptr = strlen(subDirName);
    strcpy(++bufptr, subDirName);
    bufptr += strlen(subDirName);

    *bufptr = strlen(fileName);
    strcpy(++bufptr, fileName);

    retCode = NWSystemCall(0x57, &obtainRequest, sizeof(struct OB_REQUEST),
                                 &obtainReply,   sizeof(struct OB_REPLY));
    if (retCode == 0) 
        printf("Creator name space number: %d\n", 
            obtainReply.creatorNameSpaceNumber);
    else
        printf("Obtain File or SubDirectory Information failed.  Return code = 0x%x\n",
            retCode);
    return(0);
}
