//   ͻ
//                                                                       
//    module:      nwsys.c                                               
//    abstract:    This module shows how to make 3.x system calls using  
//                 the F2 Shell Interface.  Obviously, it requires the   
//                 NetWare Shell.                                        
//                                                                       
//    environment: NetWare 3.x v3.11                                     
//                 Borland C 3.0                                         
//                                                                       
//     This software is provided as is and carries no warranty           
//     whatsoever.  Novell disclaims and excludes any and all implied    
//     warranties of merchantability, title and fitness for a particular 
//     purpose.  Novell does not warrant that the software will satisfy  
//     your requirements or that the software is without defect or error 
//     or that operation of the software will be uninterrupted.  You are 
//     using the software at your risk.  The software is not a product   
//     of Novell, Inc. or any of subsidiaries.                           
//   ͼ

#include <string.h>
#include <stdlib.h>
#include <dos.h>
#include <fcntl.h>
#include <sys/stat.h>

#include "nwsys.h"

//
//  These are some helper routines we need to make system calls.  These
//  are probably better off written in assembly, but I didn't want to tie
//  this to a specific compiler.  
//

DWORD   DWordSwap( DWORD input )
{
	struct _hilo{
		WORD    lwlb:8;     // low word, low byte
		WORD    lwhb:8;     // low word, hi  byte
		WORD    hwlb:8;     // hi  word, low byte
		WORD    hwhb:8;     // hi  word, hi  byte
	}data;

	data = *(struct _hilo *)&input; // assign it to data

	return ((long)data.lwlb << 24) | ((long)data.lwhb << 16) |
	       ((long)data.hwlb << 8)  |  (long)data.hwhb;
}

WORD    WordSwap( WORD input )
{
	struct _hilo{
		WORD    lwlb:8;     // low byte
		WORD    lwhb:8;     // hi  byte
	}data;

	data = *(struct _hilo *)&input; // assign it to data

	return data.lwlb << 8 | data.lwhb;
}

WORD    NWSystemCall(BYTE func,             // function code
		     void far * req,        // request buffer
		     WORD reqLen,           // request length
		     void far *rep,         // reply buffer
		     WORD repLen)           // reply length
{
	union   REGS    regs;
	struct  SREGS   sregs;

	segread(&sregs);

	regs.x.ax = 0xf200 | func;      // AX = F2nn 'nn' is function code
	regs.x.cx = reqLen;             // CX = request buffer length
	regs.x.dx = repLen;             // DX = reply buffer length
	regs.x.si = FP_OFF(req);        // SI = request buffer offset
	regs.x.di = FP_OFF(rep);        // DI = reply buffer offset

	sregs.ds = FP_SEG(req);         // DS = request buffer segment
	sregs.es = FP_SEG(rep);         // ES = reply buffer segment

	intdosx(&regs,&regs,&sregs);    // do the Int 21

	return (WORD)regs.h.al;         // return code is in AL
}


