//   ͻ
//                                                                       
//    module:      addtrust.c                                            
//    abstract:    This module shows how to make 3.x system calls using  
//                 the F2 Shell Interface for the SetTrustee API,        
//                 obviously it requires the NetWare Shell.              
//                                                                       
//                 The user object name entered must be of type USER     
//                 for the purposes of this example.  Supporting other   
//                 object types is quite straightforward, and is left    
//                 as an exercise to the reader.                         
//                                                                       
//                 Whatever pathname is entered must be for the          
//                 currently logged drive, as the path is not checked    
//                 in this example.  Wildcard expressions are not        
//                 supported.                                            
//                                                                       
//    environment: NetWare 3.x v3.11                                     
//                 Borland C++ 3.1                                       
//                                                                       
//     This software is provided as is and carries no warranty           
//     whatsoever.  Novell disclaims and excludes any and all implied    
//     warranties of merchantability, title and fitness for a particular 
//     purpose.  Novell does not warrant that the software will satisfy  
//     your requirements or that the software is without defect or error 
//     or that operation of the software will be uninterrupted.  You are 
//     using the software at your risk.  The software is not a product   
//     of Novell, Inc. or any of subsidiaries.                           
//                                                                       
//   ͼ
//   
//                         ****** N O T I C E ******
//
//     This software is considered pre-release and may be used at your own
//     risk and has been provided due to the many requests of our cust-
//     omers.  Support for this module will be provided at the sole
//     discretion of Novell, Inc.
//

#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <dir.h>

#include "nwsys.h"

struct TR_REQUEST {
    WORD  sfLen;            // length of the structure
    BYTE  sfCode;           // subfunction code
    BYTE  dirHandle;        // directory handle
    DWORD objectID;         // bindery object ID
    WORD  trusteeRights;    // bitmap of trustee rights
    BYTE  pathLength;       // directory path length
    BYTE  path[255];        // directory path buffer
} trusteeRequest;

struct BIND_REQUEST {
    WORD  sfLen;            // length of the structure
    BYTE  sfCode;           // subfunction code
    WORD  objectType;       // bindery object type
    BYTE  objectNameLength; // name length: 1 to 47
    BYTE  objectName[48];   // bindery object name
} binderyRequest;

struct BIND_REPLY {
    WORD  replyLen;         // length of reply buffer
    DWORD objectID;         // bindery object ID
    WORD  objectType;       // bindery object type
    BYTE  objectName[48];   // bindery object name
} binderyReply;

WORD NWSystemCall2(BYTE func,             // function code
      		       void far * req,        // request buffer
		           void far *rep)         // reply buffer
{
	union   REGS    regs;
	struct  SREGS   sregs;

	segread(&sregs);

    memset(&regs, 0, sizeof(regs));

	regs.h.ah = func;               // AH = function code
	regs.x.si = FP_OFF(req);        // SI = request buffer offset
	regs.x.di = FP_OFF(rep);        // DI = reply buffer offset

	sregs.ds = FP_SEG(req);         // DS = request buffer segment
	sregs.es = FP_SEG(rep);         // ES = reply buffer segment

	intdosx(&regs,&regs,&sregs);    // do the Int 21

	return (WORD)regs.h.al;         // return code is in AL
}

WORD GetBinderyObjectID(char *userName, WORD objectType, DWORD *objectID)
{
    int retCode;

    binderyRequest.sfLen = sizeof(binderyRequest);
    binderyRequest.sfCode = 0x35;
    binderyRequest.objectType = WordSwap(objectType);
    binderyRequest.objectNameLength = strlen(userName);
    strcpy(binderyRequest.objectName, userName);
    binderyReply.replyLen = sizeof(binderyReply);
    retCode = NWSystemCall2(0xe3, &binderyRequest, &binderyReply);
    *objectID = binderyReply.objectID;
    return(retCode);
}

BYTE GetDirectoryHandle(int diskNumber)
{
	union REGS regs;

    memset(&regs, 0, sizeof(regs));

    regs.h.ah = 0xe9;
    regs.h.al = 0x00;
    regs.x.dx = diskNumber;

	intdos(&regs,&regs);       // do the Int 21

	return(regs.h.al);         // return code is in AL
}

int main()
{
    int retCode, diskNumber;
    BYTE dirHandle;
    DWORD userObjectID;
    char userName[80], fileName[80];

    printf("Username to add: ");
    gets(userName);

    printf("Pathname and/or filename to add to: ");
    gets(fileName);

    retCode = GetBinderyObjectID(userName, 0x0001, &userObjectID);
    if (retCode != 0) {
        printf("GetBinderyObjectID call failed.  Return code = %d.\n",
            retCode);
        return(1);
    }

    diskNumber = getdisk();

    dirHandle = GetDirectoryHandle(diskNumber);

    trusteeRequest.sfLen = sizeof(trusteeRequest);
    trusteeRequest.sfCode = 0x27;
    trusteeRequest.dirHandle = dirHandle;
    trusteeRequest.objectID = userObjectID;

    /* Add Read and Write trustee rights */
    trusteeRequest.trusteeRights = 0x0001 | 0x0002; 

    strcpy(trusteeRequest.path, fileName);
    trusteeRequest.pathLength = strlen(trusteeRequest.path);;

    /* No reply packet necessary */
    retCode = NWSystemCall(0x16, &trusteeRequest, sizeof(trusteeRequest),
                                 NULL,            0);
    if (retCode != 0) {
        printf("SetTrustee call failed.  Return code = %d.\n",
            retCode);
        return(1);
    }
    return(0);
}
