/*
   SAVEPAL.CPP

   Author: Michael Joseph Newton
   CompuServe 70402,531
   Uploaded 11-28-91

      An example of how to save and restore a Turbo Vision application's
   palette to and from a binary file.
*/

void MyApp::writePalette(const char *path)
// Saves the application's palette in binary file "path"
{
   char msg[MAXLINE];
   ostrstream os(msg, sizeof msg);

   fpstream *f = new fpstream(path, ios::trunc | ios::binary);
   if(!f)
      {
      os << "\003Could not create palette file \""
         << path
         << "\""
         << ends;
      messageBox(msg, mfOKButton | mfError);
      }
   else
      {
      opstream& strm = *f;
      TPalette &palette = getPalette();
      ushort paletteLen = palette[0];
      strm.writeBytes(&palette[0], sizeof(palette[0]));
      for(int ctr = 1; ctr < paletteLen + 1; ctr++)
         strm.writeBytes(&palette[ctr], sizeof(palette[ctr]));
      f->close();
      delete f;
      }
}


void MyApp::readPalette(const char *path)
// Reads the application's palette from binary file "path"
{
   struct ffblk fcb;
   char msg[MAXLINE];
   ostrstream os(msg, sizeof msg);

   if(findfirst(path, &fcb, 0))
      {
      os << "\003Could not find palette file \""
         << path
         << "\""
         << ends;
      messageBox(msg, mfOKButton | mfError);
      return;
      }
   else
      {
      fpstream *f = new fpstream(path, ios::in | ios::binary);
      if(!f)
         {
         os << "\003Could not open palette file \""
            << path
            << "\""
            << ends;
         messageBox(msg, mfOKButton | mfError);
         return;
         }
      else
         {
         ipstream& strm = *f;
         TPalette &palette = getPalette();
         ushort paletteLen = palette[0];
         strm.readBytes(&palette[0], sizeof(palette[0]));
         for(int ctr = 1; ctr < paletteLen + 1; ctr++)
            strm.readBytes(&palette[ctr], sizeof(palette[ctr]));
         f->close();
         delete f;
         }
      }

   setState(sfExposed, False);    // Free all view buffers
   setState(sfExposed, True);     // Back to normal
   redraw();                      // Redraw it all
}
