#ifndef INTERNAL
#  define STRONG_TYPE(X) typedef struct { char c;}  *X

   STRONG_TYPE(Lroot);
   STRONG_TYPE(Lnode);
   STRONG_TYPE(Hroot);
   STRONG_TYPE(Hnode);
   STRONG_TYPE(Troot);
   STRONG_TYPE(Tnode);
   STRONG_TYPE(Mroot);
   STRONG_TYPE(Mnode);
   STRONG_TYPE(Broot);

   typedef int (*HashFnc)(void *key, unsigned hash); /* user supplied hash  */
   typedef int (*KCmpFnc)(void *data, void * key); /* user supplied compare */
   typedef void (*BEachFnc)(unsigned, void *);

#endif


#define FIND_EQ  1
#define FIND_GE  0

#define OK_DUPE  1
#define NO_DUPE  0

/*************************************************/
/************* Linked List Prototypes ************/
/*************************************************/
int   Lopen
    (Lroot *lroot,  KCmpFnc comp);

int   Lclose
    (Lroot *lroot);

Lnode Ladd_first
    (Lroot lroot,  void *data);

Lnode Ladd_last
    (Lroot lroot,  void *data);

Lnode Ladd_order
    (Lroot lroot,  void *data,  void *key, int dupe);

Lnode Ladd_before
    (Lroot lroot,  void *data,  Lnode node);

Lnode Ladd_after
    (Lroot lroot,  void *data,  Lnode node);

Lnode Lfind_first
    (Lroot lroot,  void *found);

Lnode Lfind_last
    (Lroot lroot,  void *found);

Lnode Lfind_after
    (Lroot lroot,  Lnode node,  void *found);

Lnode Lfind_before
    (Lroot lroot,  Lnode node,  void *found);

void  Lfind_node
    (Lnode node, void *found);

Lnode Lfind
    (Lroot lroot,  void *key,  void *found, int eq);

Lnode Lfind_next
    (Lroot lroot,  Lnode node,  void *key,  void *found);

int   Lmake_first
    (Lroot lroot,  Lnode node);

int   Lremove
    (Lroot lroot,  Lnode node);

int   Ltest
    (Lroot lroot,  Lnode node);

long  Lcard
    (Lroot lroot);

/*************************************************/
/************* Hash Table Prototypes *************/
/*************************************************/
int   Hopen
    (Hroot *hroot,  unsigned quan,  KCmpFnc cmp,  HashFnc hsh);

int   Hclose
    (Hroot *hroot);

Hnode Hadd
    (Hroot hroot,  void *data,  void *key);

Hnode Hfind
    (Hroot hroot,  void *key,  void *found);

void Hfind_node
    (Hnode node,  void *found);

int   Hremove
    (Hroot hroot,  Hnode node);

int   Htest
    (Hroot hroot,  Hnode node);

long  Hcard
    (Hroot hroot);

/**************************************************/
/************* Binary Tree Prototypes *************/
/**************************************************/
int   Topen
    (Troot *troot,  KCmpFnc comp);

int   Tclose
    (Troot *troot);

Tnode Tadd
    (Troot troot,  void *data,  void *key);

Tnode Tfind
    (Troot troot,  void *key,  void *found);

Tnode Tfind_first
    (Troot troot,  void *found);

Tnode Tfind_next
    (Troot troot, Tnode prior,  void *found);

void Tfind_node
    (Tnode node, void *found);

int   Tremove
    (Troot troot,  Tnode node);

int   Ttest
    (Troot troot,  Tnode node);

long  Tcard
    (Troot troot);

/****************************************************/
/************* Sparse Matrix Prototypes *************/
/****************************************************/
int   Mopen
    (Mroot *mroot,  unsigned dim,  unsigned quan);

int   Mclose
    (Mroot *mroot);

Mnode Madd
    (Mroot mroot,  void *data,   ...);

Mnode Mfind
    (Mroot mroot,  void *found,  ...);

void Mfind_node
    (Mnode node,   void *found);

int   Mremove
    (Mroot  mroot,  Mnode node);

int   Mtest
    (Mroot  mroot,  Mnode node);

long  Mcard
    (Mroot mroot);

/*************************************************/
/************* Bit Stream Prototypes *************/
/*************************************************/
int Bopen
    (Broot *root, unsigned size);

int Bclose
    (Broot *root);

int Badd
    (Broot root, unsigned bit_id);

int Bremove
    (Broot root, unsigned bit_id);

int Btoggle
    (Broot root, unsigned bit_id);

int Bcard
    (Broot root);

int Btest_in
    (Broot root, unsigned bit_id);

int Bfind_next
    (Broot root, unsigned start, unsigned *found);

int Bfor_each
    (Broot root, BEachFnc func, void *arg);

void Bunion
    (Broot root1, Broot root2, Broot *uni);

void Bintersect
    (Broot b1, Broot b2, Broot *inter);

void Bdifference
    (Broot b1, Broot b2, Broot *diff);

void Bduplicate
    (Broot orig, Broot *copy);

void Bcomplement
    (Broot orig, Broot *comp);

int Bequal
    (Broot b1, Broot b2);

int set_error_log
    (char *file_name);

void error_report (char *, int, char *, int);
