/*******************************************************************
********************************************************************
 File Name  :  UTY99CTL.H

 Description:  SAFCtl3dV2 class

 Change Log :  05/01/94
               KENWAL
               New Program

********************************************************************
*******************************************************************/


/*                                
Use:
   Use SAFCtl3dV2 instead of linking directly to ctl3dv2.dll.  This class
   makes sure ctl3dv2 is loaded from the proper directory.  If ctl3dv2 is not
   available your application will still run without the 3D effects.  
   
 MFC example:
   In your CWinApp derived class, add a member variable of SAFCtl3dV2
      public:
        SAFCtl3dV2 m_3dDll;
   In CMyWinApp::InitInstance function call SAFCtl3dV2::Auto
      m_3dDll.Auto(m_hInstance);
      
   In your main window add a function to handle the WM_SYSCOLORCHANGE message.
   Call the Ctl3dColorChange function.  
      void CMainFrame::OnSysColorChange()
      {
         CFrameWnd::OnSysColorChange();
         
         ((CMyWinApp *)AfxGetApp())->m_3dDll.Ctl3dColorChange();
      }
              
 MFC CFormView example
   If you want a CFormView to have a 3D look override the OnInitialUpdate() function
   and call Ctl3dSublcassDlg.
      void CMyFormView::OnInitialUpdate()
      {       
         ((CMyApp *)AfxGetApp())->m_3dDll.Ctl3dSubclassDlg(m_hWnd, CTL3D_ALL);
      
         CFormView::OnInitialUpdate();
      }

   


Function Reference::

Constructors
   SAFCtl3dV2()
   
   SAFCtl3dV2(BOOL bAuto)
     bAuto - If TRUE the current task (GetCurrentTask) will be registered with 
             Ctl3dv2 and auto subclassing will be turned on.  
             
Destructor
   ~SAFCtl3dV2()
     Calls Ctl3dUnregister if auto subclassing was turned on via the Constructor 
     with a single BOOL argument or the Auto function was called.
     Calls a FreeLibrary on ctl3dv2.dll if it was loaded.
             
Implementation   
   BOOL Auto(HINSTANCE hInstApp = NULL)
     Registers the application with Ctl3dv2 and turns on auto subclassing.  
     If hInstApp is NULL the instance of the current task (GetCurrentTask) 
     is used.
     
   BOOL Init()
     Initialized SAFCtl3dV2's connection with Ctl3dv2.dll.  The function
     safely loads ctl3dv2 from the windows\system directory.  If the dll
     is not already located in the windows\system directory it will look for
     it and install it before calling LoadLibrary.  
     
     You do not need to call this function.  SAFCtl3dV2 will make sure it is 
     called. 
     
   SHORT GetLastError()
     Returns the last error code. 
  

*/

#ifndef  __UTY99CTL_H 
 #define __UTY99CTL_H
 
#ifndef _INC_WINDOWS
 #include <windows.h>
#endif

#include <ctl3d.h>
 
typedef short SHORT;
                        
//Error codes                        
const SHORT CCTL3D_OK             = 0; 
const SHORT CCTL3D_E_NOFUNCTION   = 1;
const SHORT CCTL3D_E_OUTOFMEMORY  = 2;
const SHORT CCTL3D_E_LOADFAIL     = 3;   

//function typedefs      
typedef BOOL (WINAPI* PFNSUBCLASSDLG)(HWND, WORD);
typedef BOOL (WINAPI* PFNSUBCLASSDLGEX)(HWND,DWORD );
typedef WORD (WINAPI* PFNGETVER)(VOID);
typedef BOOL (WINAPI* PFNENABLED)(VOID);
typedef HBRUSH (WINAPI* PFNCTLCOLOREX)(UINT, WPARAM, LPARAM);
typedef BOOL (WINAPI* PFNCOLORCHANGE)(VOID);
typedef BOOL (WINAPI* PFNSUBCLASSCTL)(HWND);
typedef LONG (WINAPI* PFNDLGFRAMEPAINT)(HWND, UINT, WPARAM, LPARAM );
typedef BOOL (WINAPI* PFNAUTOSUBCLASS)(HINSTANCE);
typedef BOOL (WINAPI* PFNREGISTER)(HINSTANCE );
typedef BOOL (WINAPI* PFNUNREGISTER)(HINSTANCE );

//functions from helper dll's
typedef BOOL (WINAPI* PFNTASKFINDHANDLE)(VOID FAR *, HTASK );
typedef LONG (WINAPI* PFNLZCOPY)(HFILE, HFILE );


                                                               
 
class  SAFCtl3dV2
{
 public:  
   SAFCtl3dV2();
   SAFCtl3dV2(BOOL bAuto);
   ~SAFCtl3dV2();

   BOOL Auto(HINSTANCE hInstApp = NULL);
   BOOL Init();  
   SHORT GetLastError();
      
   BOOL WINAPI Ctl3dSubclassDlg(HWND, WORD);
   BOOL WINAPI Ctl3dSubclassDlgEx(HWND, DWORD);
   WORD WINAPI Ctl3dGetVer(void);
   BOOL WINAPI Ctl3dEnabled(void);
   HBRUSH WINAPI Ctl3dCtlColorEx(UINT wm, WPARAM wParam, LPARAM lParam);
   BOOL WINAPI Ctl3dColorChange(void);
   BOOL WINAPI Ctl3dSubclassCtl(HWND);
   LONG WINAPI Ctl3dDlgFramePaint(HWND, UINT, WPARAM, LPARAM);
   
   BOOL WINAPI Ctl3dAutoSubclass(HINSTANCE);
   
   BOOL WINAPI Ctl3dRegister(HINSTANCE);
   BOOL WINAPI Ctl3dUnregister(HINSTANCE);
   
 private:                                    
 
   BOOL _bInit;                  
   SHORT _sError;
   HINSTANCE _hinstDll;
   HINSTANCE _hinstSelfAuto;
   
      
   PFNSUBCLASSDLG _pfnCtl3dSubclassDlg;
   PFNSUBCLASSDLGEX _pfnCtl3dSubclassDlgEx;
   PFNGETVER _pfnCtl3dGetVer;
   PFNENABLED _pfnCtl3dEnabled;
   PFNCTLCOLOREX _pfnCtl3dCtlColorEx;
   PFNCOLORCHANGE _pfnCtl3dColorChange;
   PFNSUBCLASSCTL _pfnCtl3dSubclassCtl;
   PFNDLGFRAMEPAINT _pfnCtl3dDlgFramePaint;
   PFNAUTOSUBCLASS _pfnCtl3dAutoSubclass;
   PFNREGISTER _pfnCtl3dRegister;
   PFNUNREGISTER _pfnCtl3dUnregister;

   void GetFunctions();
   void InitPrivate();
   void AutoAuto();                   
   HINSTANCE GetInstance();
   LONG DoCopy(HFILE hfSrc, HFILE hfDest);

};
 
 
 
 
#endif   //__UTY99CTL_H