/*******************************************************************
********************************************************************
 File Name  :  UTY99CTL.CPP

 Description:  Implementation of SAFCtl3dV2 class

 Change Log :  05/01/94
               KENWAL              
               New Program

********************************************************************
*******************************************************************/
//include stdafx.h for MFC precompiled headers.  Create a empty
//header file if you don't have this header file.

#include "stdafx.h"

#include <windows.h>
#include <lzexpand.h>
#include <toolhelp.h>
#include <string.h>
#include <uty99ctl.h>

/*******************************************************************
     Function    : SAFCtl3dV2::SAFCtl3dV2

     Description :

     Parameters  : 

     Return Value: NONE 

     Comments    :
********************************************************************/

SAFCtl3dV2::SAFCtl3dV2()
{
   InitPrivate();

}
                         
/*******************************************************************
     Function    : SAFCtl3dV2::SAFCtl3dV2(BOOL bAuto)

     Description :

     Parameters  : 

     Return Value: NONE 

     Comments    :
********************************************************************/

SAFCtl3dV2::SAFCtl3dV2(BOOL bAuto)
{
   InitPrivate();

   if (bAuto)
   {          
      AutoAuto();        
   }   
}

 
/*******************************************************************
     Function    : SAFCtl3dV2::~SAFCtl3dV2

     Description :

     Parameters  : 

     Return Value: NONE 

     Comments    :
********************************************************************/

SAFCtl3dV2::~SAFCtl3dV2()
{

   if (_hinstSelfAuto)
   {
      Ctl3dUnregister(_hinstSelfAuto);  
   }

   //free module
   if (_hinstDll)
      FreeLibrary(_hinstDll);
}

/*******************************************************************
     Function    : SAFCtl3dV2::Auto

     Description :

     Parameters  :   

     Return Value: BOOL

     Comments    :
********************************************************************/

BOOL SAFCtl3dV2::Auto(HINSTANCE hInstApp)
{                  

   if (hInstApp)
   {
      if (Ctl3dRegister(hInstApp))
         if (Ctl3dAutoSubclass(hInstApp))
            _hinstSelfAuto = hInstApp;
   }
   else
   {
      AutoAuto();     
   }   
                           
   if (_hinstSelfAuto)
      return TRUE;
   else
      return FALSE;   
}

/*******************************************************************
     Function    : SAFCtl3dV2::Init

     Description :

     Parameters  : 

     Return Value: BOOL

     Comments    :
********************************************************************/

BOOL SAFCtl3dV2::Init()
{                            
   //load the library - only run one from the \windows\system directory
   char * pszBuf = new char[157];
   if (!pszBuf)
      return FALSE;
   
   UINT uRet = GetSystemDirectory(pszBuf,144 );   //leave room for dll name
   
   if (uRet > 144)
   {
      delete [] pszBuf;
      pszBuf = new char[uRet + 13];
      if (!pszBuf)
         return FALSE;
      
      uRet = GetSystemDirectory(pszBuf, uRet );
         
   }                     
   
   if (uRet == 0)
   {
      _sError = CCTL3D_E_OUTOFMEMORY;
      return FALSE;
   }         
   
   //handle case of system on root drive
   if (pszBuf[strlen(pszBuf) -1] != '\\')
      strcat(pszBuf, "\\");
                  
   strcat(pszBuf, "ctl3dv2.dll");
   //see if the file is there before trying a load library
   HINSTANCE hinstTemp = NULL;
   OFSTRUCT ofTest;
   HFILE hFileTest = OpenFile(pszBuf, &ofTest, OF_EXIST);

   if (hFileTest != HFILE_ERROR)
      hinstTemp = LoadLibrary(pszBuf);

   if (hinstTemp >= HINSTANCE_ERROR)
   {
      //get all the function pointers
      _hinstDll = hinstTemp;
      GetFunctions();
      _bInit = TRUE;
   }                                 
   else
   {
      //try to find the dll and copy it to the windows system directory if possible
      //first see if the dll is in memory... 
      HMODULE hmod = GetModuleHandle("ctl3dv2");
      if (!hmod)  //not in memory
      {
         //then try to find it
         OFSTRUCT of;
         OFSTRUCT ofDest;
         HFILE hFile = OpenFile("ctl3dv2.dll", &of, OF_READ | OF_SEARCH  );
         HFILE hFileDest;
         if (hFile != HFILE_ERROR)
         {                                                    
            LONG lCopyRet = -1;
            //copy file and load
            hFileDest = OpenFile(pszBuf, &ofDest, OF_CREATE);

            if (hFileDest != HFILE_ERROR) 
            {
               lCopyRet = DoCopy(hFile, hFileDest);
               _lclose(hFileDest);
            }
            
            _lclose(hFile);                                
                 
            if (lCopyRet > 0)
               hinstTemp = LoadLibrary(pszBuf);
               
            if (hinstTemp >= HINSTANCE_ERROR)
            {
               //get all the function pointers
               _hinstDll = hinstTemp;
               GetFunctions();
               _bInit = TRUE;
            } 
            
            
            
         }

      }
      
   }
       
   if (!_bInit && (_sError == CCTL3D_OK))               
      _sError = CCTL3D_E_LOADFAIL;


   delete [] pszBuf;   
   
   return TRUE;
   
}                                            
/*******************************************************************
     Function    : SAFCtl3dV2::GetLastError

     Description :

     Parameters  : 

     Return Value: SHORT

     Comments    :
********************************************************************/

SHORT SAFCtl3dV2::GetLastError()
{
   return _sError;
}

/*******************************************************************
     Function    : WINAPI SAFCtl3dV2::Ctl3dSubclassDlg

     Description :

     Parameters  : 

     Return Value: BOOL

     Comments    :
********************************************************************/

BOOL WINAPI SAFCtl3dV2::Ctl3dSubclassDlg(HWND hwnd, WORD w)
{                 
                
   _sError = CCTL3D_OK;
                   
   if (!_bInit)
      Init();

   if (!_bInit)
      return FALSE;  
      
   if (_pfnCtl3dSubclassDlg)
   {
      return _pfnCtl3dSubclassDlg(hwnd, w);                 

   }
   
   _sError = CCTL3D_E_NOFUNCTION;
   return FALSE;   
}
/*******************************************************************
     Function    : WINAPI SAFCtl3dV2::Ctl3dSubclassDlgEx

     Description :

     Parameters  : 

     Return Value: BOOL

     Comments    :
********************************************************************/

BOOL WINAPI SAFCtl3dV2::Ctl3dSubclassDlgEx(HWND hwnd, DWORD dw)
{     
   _sError = CCTL3D_OK;
                   
   if (!_bInit)
      Init();

   if (!_bInit)
      return FALSE;  
      
   if (_pfnCtl3dSubclassDlgEx)
   {
      return _pfnCtl3dSubclassDlgEx(hwnd, dw);
   }
   
   _sError = CCTL3D_E_NOFUNCTION;
   return FALSE;   

}
/*******************************************************************
     Function    : WINAPI SAFCtl3dV2::Ctl3dGetVer

     Description :

     Parameters  : 

     Return Value: WORD

     Comments    :
********************************************************************/

WORD WINAPI SAFCtl3dV2::Ctl3dGetVer(void)
{
   _sError = CCTL3D_OK;
                   
   if (!_bInit)
      Init();

   if (!_bInit)
      return FALSE;  
      
   if (_pfnCtl3dGetVer)
   {
      return _pfnCtl3dGetVer();
   }
   
   _sError = CCTL3D_E_NOFUNCTION;
   return 0;   



}
/*******************************************************************
     Function    : WINAPI SAFCtl3dV2::Ctl3dEnabled

     Description :

     Parameters  : 

     Return Value: BOOL

     Comments    :
********************************************************************/

BOOL WINAPI SAFCtl3dV2::Ctl3dEnabled(void)
{                     
   _sError = CCTL3D_OK;
                   
   if (!_bInit)
      Init();

   if (!_bInit)
      return FALSE;  
      
   if (_pfnCtl3dEnabled)
   {
      return _pfnCtl3dEnabled();
   }
   
   _sError = CCTL3D_E_NOFUNCTION;
   return FALSE;   


}
/*******************************************************************
     Function    : WINAPI SAFCtl3dV2::Ctl3dCtlColorEx

     Description :

     Parameters  : 

     Return Value: HBRUSH

     Comments    :
********************************************************************/

HBRUSH WINAPI SAFCtl3dV2::Ctl3dCtlColorEx(UINT wm, WPARAM wParam, LPARAM lParam)
{                   
   _sError = CCTL3D_OK;
                   
   if (!_bInit)
      Init();

   if (!_bInit)
      return FALSE;  
      
   if (_pfnCtl3dCtlColorEx)
   {
      return _pfnCtl3dCtlColorEx(wm, wParam, lParam);
   }
   
   _sError = CCTL3D_E_NOFUNCTION;
   return NULL;   


}
/*******************************************************************
     Function    : WINAPI SAFCtl3dV2::Ctl3dColorChange

     Description :

     Parameters  : 

     Return Value: BOOL

     Comments    :
********************************************************************/

BOOL WINAPI SAFCtl3dV2::Ctl3dColorChange(void)
{                                
   _sError = CCTL3D_OK;
                   
   if (!_bInit)
      Init();

   if (!_bInit)
      return FALSE;  
      
   if (_pfnCtl3dColorChange)
   {
      return _pfnCtl3dColorChange();
   }
   
   _sError = CCTL3D_E_NOFUNCTION;
   return FALSE;   


}
/*******************************************************************
     Function    : WINAPI SAFCtl3dV2::Ctl3dSubclassCtl

     Description :

     Parameters  : 

     Return Value: BOOL

     Comments    :
********************************************************************/

BOOL WINAPI SAFCtl3dV2::Ctl3dSubclassCtl(HWND hwnd)
{                
   _sError = CCTL3D_OK;
                   
   if (!_bInit)
      Init();

   if (!_bInit)
      return FALSE;  
      
   if (_pfnCtl3dSubclassCtl)
   {
      return _pfnCtl3dSubclassCtl(hwnd);
   }
   
   _sError = CCTL3D_E_NOFUNCTION;
   return FALSE;   


}
/*******************************************************************
     Function    : WINAPI SAFCtl3dV2::Ctl3dDlgFramePaint

     Description :

     Parameters  : 

     Return Value: LONG

     Comments    :
********************************************************************/

LONG WINAPI SAFCtl3dV2::Ctl3dDlgFramePaint(HWND hwnd, UINT u, WPARAM w , LPARAM l)
{                                               
   _sError = CCTL3D_OK;
                   
   if (!_bInit)
      Init();

   if (!_bInit)
      return FALSE;  
      
   if (_pfnCtl3dDlgFramePaint)
   {
      return _pfnCtl3dDlgFramePaint(hwnd, u, w, l);
   }
   
   _sError = CCTL3D_E_NOFUNCTION;
   return 0L;   


}
/*******************************************************************
     Function    : WINAPI SAFCtl3dV2::Ctl3dAutoSubclass

     Description :

     Parameters  : 

     Return Value: BOOL

     Comments    :
********************************************************************/

BOOL WINAPI SAFCtl3dV2::Ctl3dAutoSubclass(HINSTANCE hInst)
{                                    
   _sError = CCTL3D_OK;
                   
   if (!_bInit)
      Init();

   if (!_bInit)
      return FALSE;  
      
   if (_pfnCtl3dAutoSubclass)
   {
      return _pfnCtl3dAutoSubclass(hInst);
   }
   
   _sError = CCTL3D_E_NOFUNCTION;
   return FALSE;   


}

/*******************************************************************
     Function    : WINAPI SAFCtl3dV2::Ctl3dRegister

     Description :

     Parameters  : 

     Return Value: BOOL

     Comments    :
********************************************************************/

BOOL WINAPI SAFCtl3dV2::Ctl3dRegister(HINSTANCE hInst)
{
   _sError = CCTL3D_OK;
                   
   if (!_bInit)
      Init();

   if (!_bInit)
      return FALSE;  
      
   if (_pfnCtl3dRegister)
   {
      return _pfnCtl3dRegister(hInst);
   }
   
   _sError = CCTL3D_E_NOFUNCTION;
   return FALSE;   

}
/*******************************************************************
     Function    : WINAPI SAFCtl3dV2::Ctl3dUnregister

     Description :

     Parameters  : 

     Return Value: BOOL

     Comments    :
********************************************************************/

BOOL WINAPI SAFCtl3dV2::Ctl3dUnregister(HINSTANCE hInst)
{
   _sError = CCTL3D_OK;
                   
   if (!_bInit)
      Init();

   if (!_bInit)
      return FALSE;  
                          
   if (_pfnCtl3dUnregister)
   {
      return _pfnCtl3dUnregister(hInst);
   }
   
   _sError = CCTL3D_E_NOFUNCTION;
   return FALSE;   


}
   
/*******************************************************************
     Function    : SAFCtl3dV2::GetFunctions

     Description :

     Parameters  : 

     Return Value: void

     Comments    :
********************************************************************/

void SAFCtl3dV2::GetFunctions()
{
      
   _pfnCtl3dSubclassDlg = (PFNSUBCLASSDLG)GetProcAddress(_hinstDll, "Ctl3dSubclassDlg");
   _pfnCtl3dSubclassDlgEx = (PFNSUBCLASSDLGEX)GetProcAddress(_hinstDll, "Ctl3dSubclassDlgEx");
   _pfnCtl3dGetVer = (PFNGETVER)GetProcAddress(_hinstDll,"Ctl3dGetVer");
   _pfnCtl3dEnabled = (PFNENABLED)GetProcAddress(_hinstDll,"Ctl3dEnabled");
   _pfnCtl3dCtlColorEx = (PFNCTLCOLOREX)GetProcAddress(_hinstDll,"Ctl3dCtlColorEx");
   _pfnCtl3dColorChange = (PFNCOLORCHANGE)GetProcAddress(_hinstDll,"Ctl3dColorChange");
   _pfnCtl3dSubclassCtl = (PFNSUBCLASSCTL)GetProcAddress(_hinstDll, "Ctl3dSubclassCtl");
   _pfnCtl3dDlgFramePaint = (PFNDLGFRAMEPAINT)GetProcAddress(_hinstDll, "Ctl3dDlgFramePaint");
   _pfnCtl3dAutoSubclass = (PFNAUTOSUBCLASS)GetProcAddress(_hinstDll,"Ctl3dAutoSubclass");
   _pfnCtl3dRegister = (PFNREGISTER)GetProcAddress(_hinstDll,"Ctl3dRegister");
   _pfnCtl3dUnregister = (PFNUNREGISTER)GetProcAddress(_hinstDll,"Ctl3dUnregister");
         

}
/*******************************************************************
     Function    : SAFCtl3dV2::InitPrivate

     Description :

     Parameters  : 

     Return Value: void

     Comments    :
********************************************************************/

void SAFCtl3dV2::InitPrivate()
{                        
   _bInit = FALSE;       
   _hinstDll = NULL;     
   _hinstSelfAuto = NULL;
   _sError = CCTL3D_OK;      
}
/*******************************************************************
     Function    : SAFCtl3dV2::AutoAuto

     Description :

     Parameters  : 

     Return Value: void

     Comments    :
********************************************************************/

void SAFCtl3dV2::AutoAuto()
{                       
   HINSTANCE hInst = GetInstance();
   
   if (!hInst)
   {    
      return;
   }
             
   if (Ctl3dRegister(hInst))
      if (Ctl3dAutoSubclass(hInst))
         _hinstSelfAuto = hInst;

}
                            
/*******************************************************************
     Function    : SAFCtl3dV2::GetInstance

     Description :

     Parameters  : 

     Return Value: HINSTANCE

     Comments    :
********************************************************************/

HINSTANCE SAFCtl3dV2::GetInstance()
{
   //use ToolHelp.dll to find hinstance of the current task
   HTASK hTaskCur = NULL;
   TASKENTRY te;
   memset(&te, 0x00, sizeof(TASKENTRY) );
   te.dwSize = sizeof(TASKENTRY);
   OFSTRUCT of;
   char szToolHelp[] = "toolhelp.dll";                                     
   PFNTASKFINDHANDLE pfnTaskFindHandle = NULL;
   HINSTANCE hinstToolHelp = NULL;
   HINSTANCE hinstReturn = NULL;
                         
   hTaskCur = GetCurrentTask();                         
   
   if (!hTaskCur)
      return NULL;
      
      
   HFILE hfToolHelp = OpenFile( szToolHelp,
                                &of, 
                                OF_EXIST | OF_SEARCH);
       
   //don't call load library if it is not there                                   
   if (hfToolHelp != HFILE_ERROR)
   {
      if (hinstToolHelp = LoadLibrary(szToolHelp))
         pfnTaskFindHandle = (PFNTASKFINDHANDLE)GetProcAddress( hinstToolHelp, 
                                                              "TaskFindHandle");                                                      
   }
                                                                    
   if (pfnTaskFindHandle)
   {
      if (pfnTaskFindHandle(&te, hTaskCur))
         hinstReturn = te.hInst;
            
   }                                                                    
      
   if (hinstToolHelp)
      FreeLibrary(hinstToolHelp);
      
   return hinstReturn;               
         
}

/*******************************************************************
     Function    : SAFCtl3dV2::DoCopy

     Description :

     Parameters  : 

     Return Value: LONG

     Comments    :
********************************************************************/

LONG SAFCtl3dV2::DoCopy(HFILE hfSrc, HFILE hfDest)
{
   //use LZExpand.dll to find hinstance of the current task
   OFSTRUCT of;
   char szLZExpand[] = "LZExpand.dll";                                     
   PFNLZCOPY pfnLzCopy = NULL;
   HINSTANCE hinstLZExpand = NULL;
   LONG lReturn = -100;
                         
   
   HFILE hfLZExpand = OpenFile( szLZExpand,
                                &of, 
                                OF_EXIST | OF_SEARCH);
       
   //don't call load library if it is not there                                   
   if (hfLZExpand != HFILE_ERROR)
   {
      if (hinstLZExpand = LoadLibrary(szLZExpand))
         pfnLzCopy = (PFNLZCOPY)GetProcAddress( hinstLZExpand, 
                                               "LZCopy");                                                      
   }
                                                                    
   if (pfnLzCopy)
   {
      lReturn = pfnLzCopy(hfSrc, hfDest);
   }                                                                    
      
   if (hinstLZExpand)
      FreeLibrary(hinstLZExpand);
      
   return lReturn;               
         


}
