page    60,132
title   DISPLAY I/O ROUTINES for EGA/VGA in 640 x 480 graphics mode
;
;
CGA     EQU     0
EGA     EQU     1
VGA     EQU     2
EVGA    EQU     3

INCLUDE    macros.asm

;
_text   segment byte public 'code'
_text   ends
_data   segment word public 'data'
_data   ends
const   segment word public 'const'
const   ends
_bss    segment word public 'bss'
_bss    ends
;
      ; public  _beepflg
      ; public  _timepass
      ; public  timerint
      ; public  _beep_seq
      ; public  _take_timer
      ; public  _give_timer
      ; public  _plotxy
      ; public  _clrscreen
      ; public  _setrand
      ; public  _rand
      ; public  _beepon
      ; public  _beepoff
      ; public  _iskey
      ; public  _key
        public  _setmode
        public  _setcolors

        public  _pixels_wide
        public  _scan_deep
        public  _curr_vid_mode
        public  _curr_vid_mon
        public  _curr_vid_card
        public  _prior_vid_mode
        public  _max_scan_deep
        public  _bytes_per_line
;
;
dgroup  group   const, _bss, _data
        assume  cs:_text, ds:dgroup, ss:dgroup, es:dgroup
;
_data   segment word public 'data'
;
_curr_vid_seg    dw      0
_pixels_wide     dw      0
_scan_deep       dw      0
_bytes_per_line  dw      0
_curr_vid_mem    dw      0   ;in kbytes
_curr_vid_mode   dw      0
_prior_vid_mode  dw      0
_curr_vid_mon    dw      0   ;monitor type
_curr_vid_card   dw      0
_max_scan_deep   dw      0
_beepflg         dw      1
beeptime         dw      0
beepptr          dw      0
_timepass        dw      0
seed             dw      4,0
;
_data   ends
        page



_text   segment
;===================================================================
;
; setcolors(colorset, color);
;
_setcolors  proc far
        push    bp
        mov     bp,sp
        mov     bx,[bp+6]       ; get colorset
        mov     ax,[bp+8 ]      ; get color
        call    setcolor
        pop     bp
        ret
;
setcolor:
;
; sets ega palette registers
;       on entry:
;               AL = color value
;               BL = palette number
;
egasetcolors:
        mov     bh,al           ; copy color value
        mov     ah,10h          ; set palette call
        mov     al,0            ; set palette color sub-function number
        cmp     bl,16           ; overscan?
        jnz     egasc           ; jif no
        inc     al              ; change sub-function
egasc:
        int     10h
        ret
_setcolors  endp


;INCLUDE  random.inc

INCLUDE  emode.asm
INCLUDE  emapxy.asm
INCLUDE  epixrt.asm
INCLUDE  eplot.asm
INCLUDE  emplot.asm
INCLUDE  etext.asm
INCLUDE  eread.asm
INCLUDE  drawln3.asm
INCLUDE  eclrscr.asm
INCLUDE  esolbox.asm

INCLUDE  progXXX.asm
INCLUDE  prog087.asm
_text   ends
;
 end
